//java

package edu.washington.cac.calendar.data;

import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Iterator;

import junit.framework.TestCase;

import edu.washington.cac.calendar.db.DBResources;

/**
  Test the PublicEvents object
  @author Greg Barnes
  @version 1.0
 */
public class PublicEventsTest extends TestCase
{
  public PublicEventsTest(String name)
  {
    super(name);
  }

  /** A dummy student schedule event */
  private static Event STUDENT_SCHEDULE_EVENT;

  static {
    try {
      STUDENT_SCHEDULE_EVENT = 
          new Event(1, "English 101", null, 
                    new Date(Calendar.getInstance().getTime().getTime()), null, 
                    new Date(Calendar.getInstance().getTime().getTime()), null,
                    true, null, 
                    DBResources.notToBeLoadedByDefaultCreator(), 
                    null, NoRecurrence.NO_RECUR, 1, 1);
    } catch (CaldataException e) {// shouldn't happen
      e.printStackTrace();
      throw new RuntimeException(
          "dummy event creation caused CaldataException!");
    }
  }

  /**
    Test the invalidate method
   */
  public void testInvalidate() throws SQLException, ItemAccessException
  {
    PublicEvents pe = PublicEvents.getPublicEvents();
    pe.add(STUDENT_SCHEDULE_EVENT, false);
    pe.invalidate();

    // test:  only one element, and it is STUDENT_SCHEDULE_EVENT

    Iterator i = pe.elements();
    assertTrue(i.hasNext());
    Event e = (Event) i.next();
    assertSame(e, STUDENT_SCHEDULE_EVENT);
    assertTrue(!i.hasNext());

    // test:  no days are loaded or sorted

    assertTrue(pe.numberOfLoadedDays() == 0);
    assertTrue(pe.numberOfSortedDays() == 0);
  }
}
