/*++PropertiesFormatter.java++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.uwical.text;


import  edu.washington.cac.calendar.icalendar.Collectible;
import  edu.washington.cac.calendar.icalendar.Property;
import  edu.washington.cac.calendar.icalendar.Properties;
import  edu.washington.cac.calendar.icalendar.TextProp;
import  edu.washington.cac.calendar.icalendar.TextListProp;
import  edu.washington.cac.calendar.icalendar.TimeProp;
import  edu.washington.cac.calendar.icalendar.Class;
import  edu.washington.cac.calendar.icalendar.DTStamp;
import  edu.washington.cac.calendar.icalendar.Location;
import  edu.washington.cac.calendar.icalendar.UID;
import  edu.washington.cac.calendar.icalendar.XProp;
import  edu.washington.cac.calendar.icalendar.text.CollectibleFormatter;

import  edu.washington.cac.calendar.uwical.UWICal;
import  edu.washington.cac.calendar.uwical.XNames;


/**
 * Generates formatted text of Properties' contents.
 *
 * @author  slh
 * @version  0.00 2003/07/16 slh
 */
public
class  PropertiesFormatter
extends  edu.washington.cac.calendar.icalendar.text.PropertiesFormatter

{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  PropertiesFormatter  (Properties	properties	)
  {
    super( properties );
  }


  public
  PropertiesFormatter  (Properties	properties	,
			String		strIndent	)
  {
    super( properties , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  getString  (Collectible	collectible	)
  {
    Property			property	= (Property)collectible;
    CollectibleFormatter	cf		= null;

    if        (UID.class.isAssignableFrom( property.getClass(  ) )) {
      cf = null;
    } else if (Location.class.isAssignableFrom( property.getClass(  ) )) {
      cf = new LocationFormatter( (Location)property , m_strIndent );
    } else if (TimeProp.class.isAssignableFrom( property.getClass(  ) )) {
      cf = new TimePropFormatter( (TimeProp)property , m_strIndent );
    } else if (TextListProp.class.isAssignableFrom( property.getClass(  ) )) {
      cf = new TextListPropFormatter( (TextListProp)property , m_strIndent );
    } else if (TextProp.class.isAssignableFrom( property.getClass(  ) )) {
      cf = new TextPropFormatter( (TextProp)property , m_strIndent );
    } else {
      cf = new PropertyFormatter( property , m_strIndent );
    }

    return cf == null ? "" : cf.toString(  );
  }

}


/* Log:
 *  0.00  2003/07/02, 2003/07/09 - 2003/07/10, 2003/07/15 - 2003/07/16  slh
 *        create from icalendar/text/PropertiesFormatter
 */
/*--PropertiesFormatter.java------------------------------------------------*/
