/*++ParametersFormatter.java++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.uwical.text;


import  edu.washington.cac.calendar.icalendar.Collectible;
import  edu.washington.cac.calendar.icalendar.Parameter;
import  edu.washington.cac.calendar.icalendar.Parameters;
import  edu.washington.cac.calendar.icalendar.TextParam;
import  edu.washington.cac.calendar.icalendar.TextListParam;
import  edu.washington.cac.calendar.icalendar.ValueParam;
import  edu.washington.cac.calendar.icalendar.XParam;
import  edu.washington.cac.calendar.icalendar.text.CollectibleFormatter;
import  edu.washington.cac.calendar.icalendar.text.ParameterFormatter;
import  edu.washington.cac.calendar.icalendar.text.TextParamFormatter;
import  edu.washington.cac.calendar.icalendar.text.TextListParamFormatter;

import  edu.washington.cac.calendar.uwical.UWICal;
import  edu.washington.cac.calendar.uwical.XNames;


/**
 * Generates formatted text of Parameters' contents.
 *
 * @author  slh
 * @version  0.00 2003/11/26 slh
 */
public
class  ParametersFormatter
extends  edu.washington.cac.calendar.icalendar.text.ParametersFormatter
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  ParametersFormatter  (Parameters	parameters	)
  {
    super( parameters );
  }


  public
  ParametersFormatter  (Parameters	parameters	,
			String		strIndent	)
  {
    super( parameters , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  getString  (Collectible	collectible	)
  {
    Parameter			parameter	= (Parameter)collectible;
    CollectibleFormatter	cf		= null;

    if (ValueParam.class.isAssignableFrom( parameter.getClass(  ) ) ||
	XParam.class.isAssignableFrom( parameter.getClass(  ) ) &&
	(UWICal.makeXName( XNames.strParam_Id ).
			equals( parameter.getName(  ) ) )) {
      cf = null;
    } else if (TextListParam.class.isAssignableFrom(
			parameter.getClass(  ) )) {
      cf = new TextListParamFormatter(
		(TextListParam)parameter , m_strIndent );
    } else if (TextParam.class.isAssignableFrom( parameter.getClass(  ) )) {
      cf = new TextParamFormatter( (TextParam)parameter , m_strIndent );
    } else {
      cf = new ParameterFormatter( parameter , m_strIndent );
    }

    return cf == null ? "" : cf.toString(  );
  }

}


/* Log:
 *  0.01  2003/11/26  slh
 *        update for ValueTypeParam -> ValueParam change
 *  0.00  2003/07/02, 2003/07/09 - 2003/07/10, 2003/07/15 - 2003/07/16  slh
 *        create from icalendar/text/ParametersFormatter
 */
/*--ParametersFormatter.java------------------------------------------------*/
