/*++ComponentFormatter.java+++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.uwical.text;


import  edu.washington.cac.calendar.icalendar.Component;


/**
 * Generates formatted text of Component's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/09 slh
 */
public
class  ComponentFormatter
extends  edu.washington.cac.calendar.icalendar.text.ComponentFormatter
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  ComponentFormatter  (Component	component	)
  {
    super( component );
  }


  public
  ComponentFormatter  (Component	component	,
		       String		strIndent	)
  {
    super( component , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  /*Note: same as in icalendar.text.ComponentFormatter,
    but needed so dervied Properties/ComponentsFormatter is used
  */
  public
  String
  toString  (		)
  {
    Component	component	= (Component)m_collectible;

    return m_strIndent + Config.strComponentDelim + "\n" +
		new PropertiesFormatter(
			component.getProperties(  ) , m_strIndentNext ) +
		new ComponentsFormatter(
			component.getComponents(  ) , m_strIndentNext );
  }

}


/* Log:
 *  0.00  2003/07/09  slh
 *        create from icalendar/text/ComponentFormatter
 */
/*--ComponentFormatter.java-------------------------------------------------*/
