/*++UCSponsorDumper.java++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.uwical.instrumentation;


import  edu.washington.cac.calendar.data.Sponsor;


/**
 * Dump uwcal Sponsor's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/30 slh
 */
public
class  UCSponsorDumper
extends  Dumper
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  UCSponsorDumper  (Sponsor	sponsor	)
  {
    super( sponsor );
  }


  public
  UCSponsorDumper  (Sponsor	sponsor		,
		    String	strIndent	)
  {
    super( sponsor , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    return toString( false );
  }


  public
  String
  toString  (boolean	bBrief	)
  {
    Sponsor	sponsor		= (Sponsor)m_object;
    String	strName		= "Sponsor";
    String	strDump		= "";

    if (bBrief) {
      strDump += m_strIndent + strName + Config.strLabelValueSep +
		sponsor.getId(  ) + Config.strFieldSep +
		sponsor.getName(  ) + Config.strFieldSep +
		sponsor.getPhone(  ) + Config.strFieldSep +
		sponsor.getEmail(  ) + Config.strFieldSep +
		sponsor.isPublic(  ) + Config.strFieldSep +
		sponsor.getLink(  ) + Config.strFieldSep +
		sponsor.getCreator(  ).getNameDB(  ) + "\n";
    } else {
      strDump += m_strIndent + strName + Config.strLabelValueSep + "\n";
      strDump += m_strIndentNext + "sponsorid" + Config.strLabelValueSep +
		sponsor.getId(  ) + "\n";
      strDump += m_strIndentNext + "name" + Config.strLabelValueSep +
		sponsor.getName(  ) + "\n";
      strDump += m_strIndentNext + "phone" + Config.strLabelValueSep +
		sponsor.getPhone(  ) + "\n";
      strDump += m_strIndentNext + "email" + Config.strLabelValueSep +
		sponsor.getEmail(  ) + "\n";
      strDump += m_strIndentNext + "isPublic" + Config.strLabelValueSep +
		sponsor.isPublic(  ) + "\n";
      strDump += m_strIndentNext + "link" + Config.strLabelValueSep +
		sponsor.getLink(  ) + "\n";
      strDump += m_strIndentNext + "creator" + Config.strLabelValueSep +
		(sponsor.getCreator(  ) == null
		 ? null : sponsor.getCreator(  ).getNameDB(  )) + "\n";
    }

    return strDump;
  }

}


/* Log:
 *  0.00  2003/07/22 - 2003/07/23, 2003/07/30  slh
 *        create
 */
/*--UCSponsorDumper.java----------------------------------------------------*/
