/*++UCLocationDumper.java+++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.uwical.instrumentation;


import  edu.washington.cac.calendar.data.Location;


/**
 * Dump uwcal Location's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/30 slh
 */
public
class  UCLocationDumper
extends  Dumper
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  UCLocationDumper  (Location	location	)
  {
    super( location );
  }


  public
  UCLocationDumper  (Location	location	,
		     String	strIndent	)
  {
    super( location , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    return toString( false );
  }


  public
  String
  toString  (boolean	bBrief	)
  {
    Location	location	= (Location)m_object;
    String	strName		= "Location";
    String	strDump		= "";

    if (bBrief) {
      strDump += m_strIndent + strName + Config.strLabelValueSep +
		location.getId(  ) + Config.strFieldSep +
		location.isLocation(  ) + Config.strFieldSep +
		location.getAddress(  ) + Config.strFieldSep +
		location.getSubaddress(  ) + Config.strFieldSep +
		location.isPublic(  ) + Config.strFieldSep +
		location.getLink(  ) + Config.strFieldSep +
		location.getCreator(  ).getNameDB(  ) + "\n";
								/* RETURN */
    } else {
      strDump += m_strIndent + strName + Config.strLabelValueSep + "\n";
      strDump += m_strIndentNext + "locationid" + Config.strLabelValueSep +
		location.getId(  ) + "\n";
      strDump += m_strIndentNext + "isLocation()" + Config.strLabelValueSep +
		location.isLocation(  ) + "\n";
      strDump += m_strIndentNext + "address" + Config.strLabelValueSep +
		location.getAddress(  ) + "\n";
      strDump += m_strIndentNext + "subaddress" + Config.strLabelValueSep +
		location.getSubaddress(  ) + "\n";
      strDump += m_strIndentNext + "isPublic" + Config.strLabelValueSep +
		location.isPublic(  ) + "\n";
      strDump += m_strIndentNext + "link" + Config.strLabelValueSep +
		location.getLink(  ) + "\n";
      strDump += m_strIndentNext + "creator" + Config.strLabelValueSep +
		(location.getCreator(  ) == null
		 ? null : location.getCreator(  ).getNameDB(  )) + "\n";
/*
      strDump += m_strIndentNext + "toString()" + Config.strLabelValueSep +
		location.toString(  ) + "\n";
*/
    }

    return strDump;
  }

}


/* Log:
 *  0.00  2003/06/24, 2003/07/22 - 2003/07/24, 2003/07/30  slh
 *        create
 */
/*--UCLocationDumper.java---------------------------------------------------*/
