/*++UCKeywordsDumper.java+++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.uwical.instrumentation;


import  java.util.Iterator;

import  edu.washington.cac.calendar.data.NoSuchItemException;
import  edu.washington.cac.calendar.data.Keywords;
import  edu.washington.cac.calendar.data.Keyword;
import  edu.washington.cac.calendar.data.EventsI;


/**
 * Dump uwcal Keywords' contents.
 *
 * @author  slh
 * @version  0.00 2003/07/23 slh
 */
public
class  UCKeywordsDumper
extends  Dumper
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  UCKeywordsDumper  (Keywords	keywords	)
  {
    this( keywords , null );
  }


  public
  UCKeywordsDumper  (Keywords	keywords	,
		     String	strIndent	)
  {
    super( keywords , strIndent );

    m_eventsi = null;
  }


  public
  UCKeywordsDumper  (Iterator	iter	,
		     EventsI	eventsi	)
  {
    this( iter , eventsi , null );
  }


  public
  UCKeywordsDumper  (Iterator	iter		,
		     EventsI	eventsi		,
		     String	strIndent	)
  {
    super( iter , strIndent );

    if (iter == null) {
      throw new NullPointerException( "UCEventDumper.UCEventDumper()" +
		": (Iterator) iter is null" );
    }
    if (eventsi == null) {
      throw new NullPointerException( "UCEventDumper.UCEventDumper()" +
		": (EventsI) eventsi is null" );
    }

    m_eventsi = eventsi;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    return toString( false );
  }


  public
  String
  toString  (boolean	bBrief	)
  {
    Iterator	iter;
    Keywords	keywords;
    String	strName		= "Keywords";
    String	strDump		= "";

    strDump += m_strIndent + strName +
		(Config.bBrackets ? Config.strOpenBracket : "") + "\n";

    if (m_eventsi == null) {
      iter = ((Keywords)m_object).elements(  );
      for ( ; iter.hasNext(  ) ; ) {
	strDump += new UCKeywordDumper(
			(Keyword)iter.next(  ) , m_strIndentNext ).
			toString( bBrief );
      }
    } else {
      iter = (Iterator)m_object;
      for ( ; iter.hasNext(  ) ; ) {
	try {
	  strDump += new UCKeywordDumper( 
			m_eventsi.getKeywords(  ).getKeyword(
				((Integer)iter.next(  )).intValue(  ) ) ,
			m_strIndentNext ).
			toString( bBrief );
	} catch (NoSuchItemException    e       ) {
	  strDump += m_strIndent + "ERROR: " + e.getLocalizedMessage(  );
	}
      }
    }

    if (Config.bBrackets || Config.bEndTags) {
      strDump += m_strIndent +
		(Config.bBrackets ? Config.strCloseBracket : "") +
		(Config.bEndTags ? strName : "") + "\n";
    }

    return strDump;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/
  protected  EventsI		m_eventsi;

}


/* Log:
 *  0.00  2003/07/22 - 2003/07/23  slh
 *        create
 */
/*--UCKeywordsDumper.java---------------------------------------------------*/
