/*++UCKeywordDumper.java++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.uwical.instrumentation;


import  edu.washington.cac.calendar.data.Keyword;


/**
 * Dump uwcal Keyword's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/30 slh
 */
public
class  UCKeywordDumper
extends  Dumper
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  UCKeywordDumper  (Keyword	keyword	)
  {
    this( keyword , null );
  }


  public
  UCKeywordDumper  (Keyword	keyword		,
		    String	strIndent	)
  {
    super( keyword , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    return toString( false );
  }


  public
  String
  toString  (boolean	bBrief	)
  {
    Keyword	keyword		= (Keyword)m_object;
    String	strName		= "Keyword";
    String	strDump		= "";

    if (bBrief) {
      strDump += m_strIndent + strName + Config.strLabelValueSep +
                  keyword.getId(  ) + Config.strFieldSep +
                  keyword.getWord(  ) + Config.strFieldSep +
                  keyword.getLongdesc(  ) + Config.strFieldSep +
                  keyword.isPublic(  ) + Config.strFieldSep +
                  keyword.getCreator(  ).getNameDB(  ) + "\n";
    } else {
      strDump += m_strIndent + strName + Config.strLabelValueSep + "\n";
      strDump += m_strIndentNext + "keywordid" + Config.strLabelValueSep +
		keyword.getId(  ) + "\n";
      strDump += m_strIndentNext + "word" + Config.strLabelValueSep +
		keyword.getWord(  ) + "\n";
      strDump += m_strIndentNext + "longdesc" + Config.strLabelValueSep +
		keyword.getLongdesc(  ) + "\n";
      strDump += m_strIndentNext + "isPublic" + Config.strLabelValueSep +
		keyword.isPublic(  ) + "\n";
      strDump += m_strIndentNext + "creator" + Config.strLabelValueSep +
		(keyword.getCreator(  ) == null
		 ? null : keyword.getCreator(  ).getNameDB(  )) + "\n";
    }

    return strDump;
  }

}


/* Log:
 *  0.00  2003/07/22 - 2003/07/24, 2003/07/30  slh
 *        create
 */
/*--UCKeywordDumper.java----------------------------------------------------*/
