/*++UCEventsDumper.java+++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.uwical.instrumentation;


import  java.util.Iterator;

import  edu.washington.cac.calendar.data.EventsI;
import  edu.washington.cac.calendar.data.Event;


/**
 * Dump uwcal EventsI's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/24 slh
 */
public
class  UCEventsDumper
extends  Dumper
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  UCEventsDumper  (EventsI	eventsi	)
  {
    super( eventsi );
  }


  public
  UCEventsDumper  (EventsI	eventsi		,
		   String	strIndent	)
  {
    super( eventsi , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    return toString( false );
  }


  public
  String
  toString  (boolean	bBrief	)
  {
    Iterator	iter;
    EventsI	eventsi		= (EventsI)m_object;
    String	strName		= "Events";
    String	strDump		= "";

    strDump += m_strIndent + strName +
		(Config.bBrackets ? Config.strOpenBracket : "") + "\n";
    iter = eventsi.sortedElements(  );
    for ( ; iter.hasNext(  ) ; ) {
      strDump += new UCEventDumper(
		(Event)iter.next(  ) , eventsi , m_strIndentNext ).
		toString( bBrief );
    }
    if (Config.bBrackets || Config.bEndTags) {
      strDump += m_strIndent +
		(Config.bBrackets ? Config.strCloseBracket : "") +
		(Config.bEndTags ? strName : "");
    }

    return strDump;
  }

}


/* Log:
 *  0.00  2003/07/22 - 2003/07/24  slh
 *        create
 */
/*--UCEventsDumper.java-----------------------------------------------------*/
