/*++UCEventDumper.java++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.uwical.instrumentation;


import  edu.washington.cac.calendar.data.Event;
import  edu.washington.cac.calendar.data.EventsI;


/**
 * Dump uwcal Event's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/30 slh
 */
public
class  UCEventDumper
extends  Dumper
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  UCEventDumper  (Event		event	,
		  EventsI	eventsi	)
  {
    this( event , eventsi , null );
  }


  public
  UCEventDumper  (Event		event		,
		  EventsI	eventsi		,
		  String	strIndent	)
  {
    super( event , strIndent );

    if (eventsi == null) {
      throw new NullPointerException( "UCEventDumper.UCEventDumper()" +
		": (EventsI) eventsi is null" );
    }

    m_eventsi = eventsi;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    return toString( false );
  }


  public
  String
  toString  (boolean	bBrief	)
  {
    Event	event		= (Event)m_object;
    String	strName		= "Event";
    String	strDump		= "";

    if (bBrief) {
      strDump += m_strIndent + strName + Config.strLabelValueSep +
		event.getId(  ) + Config.strFieldSep +
		event.getStartdate(  ) + Config.strSubFieldSep +
		event.getStarttime(  ) + Config.strFieldSep +
		event.getEnddate(  ) + Config.strSubFieldSep +
		event.getEndtime(  ) + Config.strFieldSep +
		event.getShortdesc(  ) + "\n";
    } else {
      strDump += m_strIndent + strName + Config.strLabelValueSep + "\n";
      strDump += m_strIndentNext + "shortdesc" + Config.strLabelValueSep +
		event.getShortdesc(  ) + "\n";
      strDump += m_strIndentNext + "longdesc" + Config.strLabelValueSep +
		event.getLongdesc(  ) + "\n";
/*
      strDump += m_strIndentNext + "startCalendar" + Config.strLabelValueSep +
		event.startCalendar(  ) + "\n";
      strDump += m_strIndentNext + "endCalendar" + Config.strLabelValueSep +
		event.endCalendar(  ) + "\n";
*/
      strDump += m_strIndentNext + "startdate" + Config.strLabelValueSep +
		event.getStartdate(  ) + "\n";
      strDump += m_strIndentNext + "starttime" + Config.strLabelValueSep +
		event.getStarttime(  ) + "\n";
/*
      strDump += m_strIndentNext + "getStarttimeString :\t" +
		event.getStarttimeString(  ) + "\n";
*/
      strDump += m_strIndentNext + "enddate" + Config.strLabelValueSep +
		event.getEnddate(  ) + "\n";
      strDump += m_strIndentNext + "endtime" + Config.strLabelValueSep +
		event.getEndtime(  ) + "\n";
/*
      strDump += m_strIndentNext + "getEndtimeString :\t" +
		event.getEndtimeString(  ) + "\n";
*/
      strDump += m_strIndentNext + "isPublic" + Config.strLabelValueSep +
		event.isPublic(  ) + "\n";
      strDump += m_strIndentNext + "link" + Config.strLabelValueSep +
		event.getLink(  ) + "\n";
      strDump += m_strIndentNext + "creator" + Config.strLabelValueSep +
		(event.getCreator(  ) == null
		? null : event.getCreator(  ).getNameDB(  )) + "\n";
      strDump += m_strIndentNext + "cost" + Config.strLabelValueSep +
		event.getCost(  ) + "\n";
      strDump += m_strIndentNext + "eventid" + Config.strLabelValueSep +
		event.getId(  ) + "\n";

      strDump += m_strIndentNext + "locationid" + Config.strLabelValueSep +
		event.getLocationid(  ) + "\n";
      strDump += new UCLocationDumper(
			event.getLocation( m_eventsi.getLocations(  ) ) ,
			m_strIndentNext + Config.strIndentIncr ).
			toString( bBrief );

      strDump += m_strIndentNext + "sponsorid" + Config.strLabelValueSep +
		event.getSponsorid(  ) + "\n";
      strDump += new UCSponsorDumper(
		event.getSponsor( m_eventsi ) ,
		m_strIndentNext + Config.strIndentIncr ).
		toString( bBrief );

      strDump += new UCKeywordsDumper(
		event.getKeywords(  ) , m_eventsi , m_strIndentNext ).
		toString( bBrief );
    }

    return strDump;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/
  protected  EventsI		m_eventsi;

}


/* Log:
 *  0.00  2003/07/22 - 2003/07/24, 2003/07/30  slh
 *        create
 */
/*--UCEventDumper.java------------------------------------------------------*/
