/*++TextListPropXMLer.java++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.xml;


import  java.util.Iterator;

import  edu.washington.cac.calendar.icalendar.TextListProp;


/**
 * Generates XML of TextListProp's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/16 slh
 */
public
class  TextListPropXMLer
extends  TextPropXMLer
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  TextListPropXMLer  (TextListProp	tlp	)
  {
    super( tlp , null );
  }


  public
  TextListPropXMLer  (TextListProp	tlp		,
		      String		strIndent	)
  {
    super( tlp , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  getValues  (		)
  {
    Iterator		iter;
    TextListProp	tlp		= (TextListProp)m_collectible;
    String		strXML		= "";

    for (iter = tlp.getList(  ) ; iter.hasNext(  ) ; ) {
      strXML += genValueClause(
		tlp.checkUnescapeText( iter.next(  ).toString(  ) ) );
    }

    return strXML;
  }

}


/* Log:
 *  0.00  2003/07/16  slh
 *        create from PropertyXMLer and text/TextListPropFormatter
 */
/*--TextListPropXMLer.java--------------------------------------------------*/
