/*++TextListParamXMLer.java+++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.xml;


import  java.util.Iterator;

import  edu.washington.cac.calendar.icalendar.TextListParam;


/**
 * Generates XML of TextListParam's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/16 slh
 */
public
class  TextListParamXMLer
extends  TextParamXMLer
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  TextListParamXMLer  (TextListParam	tlp	)
  {
    super( tlp );
  }


  public
  TextListParamXMLer  (TextListParam	tlp		,
		       String		strIndent	)
  {
    super( tlp , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  getValues  (		)
  {
    Iterator		iter;
    TextListParam	tlp		= (TextListParam)m_collectible;
    String		strXML		= "";

    for (iter = tlp.getList(  ) ; iter.hasNext(  ) ; ) {
      strXML += genValueClause(
		tlp.getName(  ) ,
		tlp.checkUnquoteText( iter.next(  ).toString(  ) ) );
    }

    return strXML;
  }

}


/* Log:
 *  0.00  2003/07/16  slh
 *        create from ParameterXMLer and text/TextListParamFormatter
 */
/*--TextListParamXMLer.java-------------------------------------------------*/
