/*++PropertyXMLer.java++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.xml;


import  edu.washington.cac.calendar.icalendar.Property;


/**
 * Generates XML of Property's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/16 slh
 */
public
class  PropertyXMLer
extends  CollectibleXMLer
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  PropertyXMLer  (Property	property	)
  {
    super( property , null );
  }


  public
  PropertyXMLer  (Property	property	,
		  String	strIndent	)
  {
    super( property , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    Property	property	= (Property)m_collectible;
    String	strXML		= "";

    if (!Config.bParamsAsAttribs) {
      strXML += m_strIndent + genBeginTag( property.getName(  ) ) + "\n";
    } else {
      strXML += m_strIndent + Config.strBeginOpen +
		property.getName(  ) +
		new ParametersXMLer(
			property.getParameters(  ) , m_strIndentNext ) +
		Config.strBeginClose + "\n";
    }

    if (!Config.bParamsAsAttribs) {
      strXML += new ParametersXMLer(
			property.getParameters(  ) , m_strIndentNext );
    }

    strXML += getValues(  );

    strXML += m_strIndent + genEndTag( property.getName(  ) ) + "\n";

    return strXML;
  }


  public
  String
  getValues  (		)
  {
    return genValueClause( getString(  ) );
  }


  public
  String
  getString  (		)
  {
    return ((Property)m_collectible).getString(  );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  String
  genValueClause  (String	strValue	)
  {
    return m_strIndentNext + genBeginTag( Config.strPropValueTag ) +
		xmlValue( strValue ) +
		genEndTag( Config.strPropValueTag ) + "\n";
  }

}


/* Log:
 *  0.00  2003/06/24, 2003/07/01, 2003/07/16  slh
 *        create
 */
/*--PropertyXMLer.java------------------------------------------------------*/
