/*++PropertiesXMLer.java++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.xml;


import  edu.washington.cac.calendar.icalendar.Collectible;
import  edu.washington.cac.calendar.icalendar.Property;
import  edu.washington.cac.calendar.icalendar.Properties;
import  edu.washington.cac.calendar.icalendar.TextProp;
import  edu.washington.cac.calendar.icalendar.TextListProp;


/**
 * Generates XML of Properties' contents.
 *
 * @author  slh
 * @version  0.00 2003/07/16 slh
 */
public
class  PropertiesXMLer
extends  CollectionXMLer
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  PropertiesXMLer  (Properties	properties	)
  {
    super( properties );
  }


  public
  PropertiesXMLer  (Properties	properties	,
		    String	strIndent	)
  {
    super( properties , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  getString  (Collectible	collectible	)
  {
    Property		property	= (Property)collectible;
    CollectibleXMLer	cx		= null;

    if        (TextListProp.class.isAssignableFrom( property.getClass(  ) )) {
      cx = new TextListPropXMLer( (TextListProp)property , m_strIndentNext );
    } else if (TextProp.class.isAssignableFrom( property.getClass(  ) )) {
      cx = new TextPropXMLer( (TextProp)property , m_strIndentNext );
    } else {
      cx = new PropertyXMLer( property , m_strIndentNext );
    }

    return cx == null ? "" : cx.toString(  );
  }

}


/* Log:
 *  0.00  2003/06/24, 2003/07/16  slh
 *        create
 */
/*--PropertiesXMLer.java----------------------------------------------------*/
