/*++ParametersXMLer.java++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.xml;


import  java.util.Iterator;

import  edu.washington.cac.calendar.icalendar.Collectible;
import  edu.washington.cac.calendar.icalendar.Collection;
import  edu.washington.cac.calendar.icalendar.Parameter;
import  edu.washington.cac.calendar.icalendar.Parameters;
import  edu.washington.cac.calendar.icalendar.TextParam;
import  edu.washington.cac.calendar.icalendar.TextListParam;


/**
 * Generates XML of Parameters' contents.
 *
 * @author  slh
 * @version  0.00 2003/07/16 slh
 */
public
class  ParametersXMLer
extends  CollectionXMLer
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  ParametersXMLer  (Parameters	parameters	)
  {
    super( parameters );
  }


  public
  ParametersXMLer  (Parameters	parameters	,
		    String	strIndent	)
  {
    super( parameters , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  getString  (Collectible	collectible	)
  {
    Parameter		parameter	= (Parameter)collectible;
    CollectibleXMLer	cx		= null;

    if        (TextListParam.class.isAssignableFrom(
			parameter.getClass(  ) )) {
      cx = new TextListParamXMLer(
		(TextListParam)parameter , m_strIndentNext );
    } else if (TextParam.class.isAssignableFrom( parameter.getClass(  ) )) {
      cx = new TextParamXMLer( (TextParam)parameter , m_strIndentNext );
    } else {
      cx = new ParameterXMLer( parameter , m_strIndentNext );
    }

    return cx == null ? "" : cx.toString(  );
  }


  public
  String
  toString  (		)
  {
    Collection	collection	= (Collection)m_collectible;
    Iterator	iter;
    String	str		= "";

    if (!Config.bParamsAsAttribs) {
      return super.toString(  );				/*RETURN*/
    } else {
      if (collection != null && collection.size(  ) > 0) {
	for (iter = collection.elements(  ) ; iter.hasNext(  ) ; ) {
	  str += getString( (Collectible)iter.next(  ) );
	}
      }

      return str;						/*RETURN*/
    }
  }

}


/* Log:
 *  0.00  2003/06/24, 2003/07/16  slh
 *        create
 */
/*--ParametersXMLer.java----------------------------------------------------*/

