/*++ParameterXMLer.java+++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.xml;


import  edu.washington.cac.calendar.icalendar.Parameter;


/**
 * Generates XML of Parameter's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/16 slh
 */
public
class  ParameterXMLer
extends  CollectibleXMLer
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  ParameterXMLer  (Parameter	parameter	)
  {
    super( parameter );
  }


  public
  ParameterXMLer  (Parameter	parameter	,
		   String	strIndent	)
  {
    super( parameter , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    Parameter	parameter	= (Parameter)m_collectible;
    String	strXML		= "";

    if (!Config.bParamsAsAttribs) {
      strXML += m_strIndent + genBeginTag( parameter.getName(  ) ) + "\n";
    }

    strXML += getValues(  );

    if (!Config.bParamsAsAttribs) {
      strXML += m_strIndent + genEndTag( parameter.getName(  ) ) + "\n";
    }

    return strXML;
  }


  public
  String
  getValues  (		)
  {
    return genValueClause(
		((Parameter)m_collectible).getName(  ) , getString(  ) );
  }


  public
  String
  getString  (		)
  {
    return ((Parameter)m_collectible).getString(  );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  String
  genValueClause  (String	strName		,
		   String	strValue	)
  {
    if (!Config.bParamsAsAttribs) {
      return m_strIndentNext + genBeginTag( Config.strParamValueTag ) +
		xmlValue( strValue ) +
		genEndTag( Config.strParamValueTag ) + "\n";	/*RETURN*/
    } else {
      return Config.strAttribSep + strName + Config.strAttribEqual +
		Config.strAttribQuote + xmlValue( strValue ) +
		Config.strAttribQuote;				/*RETURN*/
    }
  }

}


/* Log:
 *  0.00  2003/06/24, 2003/07/01, 2003/07/16  slh
 *        create
 */
/*--ParameterXMLer.java-----------------------------------------------------*/
