/*++ComponentXMLer.java+++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.xml;


import  edu.washington.cac.calendar.icalendar.Component;


/**
 * Generates XML of Component's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/02 slh
 */
public
class  ComponentXMLer
extends  CollectibleXMLer
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  ComponentXMLer  (Component	component	)
  {
    super( component );
  }


  public
  ComponentXMLer  (Component	component	,
		   String	strIndent	)
  {
    super( component , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    Component	component	= (Component)m_collectible;

    return m_strIndent + genBeginTag( component.getName(  ) ) + "\n" +
		new PropertiesXMLer(
			component.getProperties(  ) , m_strIndentNext ) +
		new ComponentsXMLer(
			component.getComponents(  ) , m_strIndentNext ) +
		m_strIndent + genEndTag( component.getName(  ) ) + "\n";
  }

}


/* Log:
 *  0.00  2003/06/24, 2003/07/02  slh
 *        create
 */
/*--ComponentXMLer.java-----------------------------------------------------*/
