/*++CollectibleXMLer.java+++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.xml;


import  java.util.StringTokenizer;

import  edu.washington.cac.calendar.icalendar.Collectible;


/**
 * Base class for XML generators for Collectible-derived classes.
 *
 * @author  slh
 * @version  0.00 2003/07/16 slh
 */
abstract public
class  CollectibleXMLer
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  CollectibleXMLer  (Collectible	collectible	)
  {
    this( collectible , null );
  }


  /*Note: this is the base constructor*/
  public
  CollectibleXMLer  (Collectible	collectible	,
		     String		strIndent	)
  {
    if (collectible == null) {
      throw new NullPointerException(
		"CollectibleXMLer: CollectibleXMLer():" +
		" (Collectible) collectible is null" );
    }

    m_collectible = collectible;
    if (strIndent == null) {
      m_strIndent = "";
    } else {
      m_strIndent = strIndent;
      m_strIndentNext = strIndent + Config.strIndentIncr;
    }
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  String
  genBeginTag  (String	strName	)
  {
    return Config.strBeginOpen + strName + Config.strBeginClose;
  }


  protected
  String
  genEndTag  (String	strName	)
  {
    return Config.strEndOpen + strName + Config.strEndClose;
  }


  protected
  String
  xmlValue  (String	strValue	)
  {
    StringTokenizer	st;
    String		strToken;
    String		strXML		= "";

//???assumes no entities in input
    st = new StringTokenizer( strValue , Config.strXMLReservedChar , true );
    for ( ; st.hasMoreTokens(  ) ; ) {
      strToken = st.nextToken(  );
      if (1 == strToken.length(  ) &&
	  -1 != Config.strXMLReservedChar.indexOf( strToken )) {
	strXML += Config.astrXMLReservedEntity[
			Config.strXMLReservedChar.indexOf( strToken )];
      } else {
	strXML += strToken;
      }
    }

    return strXML;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  /*Assert: m_collectible never null after construction*/
  protected  Collectible	m_collectible;
  /*Assert: m_strIndent never null after construction*/
  protected  String		m_strIndent;
  protected  String		m_strIndentNext;

}


/* Log:
 *  0.00  2003/06/24, 2003/07/01, 2003/07/16  slh
 *        create
 */
/*--CollectibleXMLer.java---------------------------------------------------*/
