/*++TimePropFormatter.java++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.text;


import  java.util.SimpleTimeZone;
import  java.text.SimpleDateFormat;

import  edu.washington.cac.calendar.icalendar.TimeProp;


/**
 * Generates formatted text of TimeProp's contents.
 *
 * @author  slh
 * @version  0.00 2003/09/15 slh
 */
public
class  TimePropFormatter
extends  PropertyFormatter
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  TimePropFormatter  (TimeProp	timeprop	)
  {
    super( timeprop , null );
  }


  public
  TimePropFormatter  (TimeProp	timeprop	,
		      String	strIndent	)
  {
    super( timeprop , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  String
  getString  (		)
  {
    return getString( (TimeProp)m_collectible );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/
/*-------------------------------------- Support for derived packages	*/

  static public
  String
  getString  (TimeProp	timeprop	)
  {
    SimpleDateFormat	sdf;
    SimpleTimeZone	stz		= new SimpleTimeZone( 0 , "GMT" );

    if (timeprop.getType(  ) == timeprop.DATE) {
      sdf = new SimpleDateFormat( "MMM d, yyyy" );
    } else {
      sdf = new SimpleDateFormat( "MMM d, yyyy hh:mm aa" );
    }
    if (timeprop.isUTC(  )) {
      /*void*/sdf.setTimeZone( stz );
    }

    return sdf.format( timeprop.get(  ) ) +
		(timeprop.isUTC(  ) ? " GMT" : "");
  }

}


/* Log:
 *  0.01  2003/09/15  slh
 *        getString(): need to set tz when gmt
 *  0.00  2003/07/09, 2003/07/15  slh
 *        create from PropertyFormatterer
 */
/*--TimePropFormatter.java--------------------------------------------------*/
