/*++TextListPropFormatter.java++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.text;


import  java.util.Iterator;

import  edu.washington.cac.calendar.icalendar.TextListProp;


/**
 * Generates formatted text of TextListProp's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/15 slh
 */
public
class  TextListPropFormatter
extends  TextPropFormatter
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  TextListPropFormatter  (TextListProp	tlp	)
  {
    super( tlp , null );
  }


  public
  TextListPropFormatter  (TextListProp	tlp		,
			  String	strIndent	)
  {
    super( tlp , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  String
  getString  (		)
  {
    return getString( (TextListProp)m_collectible , m_strIndentSecondary );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/
/*-------------------------------------- Support for derived packages	*/

  static public
  String
  getString  (TextListProp	tlp		,
	      String		strIndent	)
  {
    String		strSep;
    Iterator		iter;
    String		strText		= "";

    if (!Config.bMultilineMultivalues) {
      strSep = Config.strPropValueSep;
    } else {
      strSep = "\n" + strIndent + Config.strNameValueSepSecondary;
    }

    for (iter = tlp.getList(  ) ; iter.hasNext(  ) ; ) {
      strText += tlp.checkUnescapeText( iter.next(  ).toString(  ) );
      if (iter.hasNext(  )) {
	strText += strSep;
      }
    }

    return strText;
  }

}


/* Log:
 *  0.00  2003/07/10, 2003/07/15  slh
 *        create from PropertyFormatterer
 */
/*--TextListPropFormatter.java----------------------------------------------*/
