/*++TextListParamFormatter.java+++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.text;


import  java.util.Iterator;

import  edu.washington.cac.calendar.icalendar.TextListParam;


/**
 * Generates formatted text of TextListParam's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/15 slh
 */
public
class  TextListParamFormatter
extends  TextParamFormatter
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  TextListParamFormatter  (TextListParam	tlp	)
  {
    super( tlp );
  }


  public
  TextListParamFormatter  (TextListParam	tlp		,
			   String		strIndent	)
  {
    super( tlp , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  String
  getString  (		)
  {
    String		strSep;
    Iterator		iter;
    TextListParam	tlp		= (TextListParam)m_collectible;
    String		strText		= "";

    if (!Config.bMultilineMultivalues) {
      strSep = Config.strParamValueSep;
    } else {
      strSep = "\n" + m_strIndentSecondary + Config.strNameValueSepSecondary;
    }

    for (iter = tlp.getList(  ) ; iter.hasNext(  ) ; ) {
      strText += tlp.checkUnquoteText( iter.next(  ).toString(  ) );
      if (iter.hasNext(  )) {
	strText += strSep;
      }
    }

    return strText;
  }

}


/* Log:
 *  0.00  2003/07/09 - 2003/07/10, 2003/07/15  slh
 *        create from ParameterFormatter
 */
/*--TextListParamFormatter.java---------------------------------------------*/
