/*++PropertyFormatter.java++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.text;


import  edu.washington.cac.calendar.icalendar.Property;
import  edu.washington.cac.calendar.icalendar.Parameters;


/**
 * Generates formatted text of Property's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/16 slh
 */
public
class  PropertyFormatter
extends  CollectibleFormatter
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  PropertyFormatter  (Property	property	)
  {
    super( property , null );
  }


  public
  PropertyFormatter  (Property	property	,
		      String	strIndent	)
  {
    super( property , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    return  m_strIndentPrimary + getString(  ) + "\n" +
		new ParametersFormatter(
			getParameters(  ) , m_strIndentNext );
  }

/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  String
  getString  (		)
  {
    return ((Property)m_collectible).getString(  );
  }


  protected
  Parameters
  getParameters  (		)
  {
    return ((Property)m_collectible).getParameters(  );
  }

}


/* Log:
 *  0.00  2003/07/02, 2003/07/09 - 2003/07/10, 2003/07/16  slh
 *        create from PropertyXMLer
 */
/*--PropertyFormatter.java--------------------------------------------------*/
