/*++ParametersFormatter.java++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.text;


import  edu.washington.cac.calendar.icalendar.Collectible;
import  edu.washington.cac.calendar.icalendar.Parameter;
import  edu.washington.cac.calendar.icalendar.Parameters;
import  edu.washington.cac.calendar.icalendar.TextParam;
import  edu.washington.cac.calendar.icalendar.TextListParam;
import  edu.washington.cac.calendar.icalendar.ValueParam;


/**
 * Generates formatted text of Parameters' contents.
 *
 * @author  slh
 * @version  0.01 2003/11/26 slh
 */
public
class  ParametersFormatter
extends  CollectionFormatter
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  ParametersFormatter  (Parameters	parameters	)
  {
    super( parameters );
  }


  public
  ParametersFormatter  (Parameters	parameters	,
			String		strIndent	)
  {
    super( parameters , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  getString  (Collectible	collectible	)
  {
    Parameter			parameter	= (Parameter)collectible;
    CollectibleFormatter	cf		= null;

    if        (ValueParam.class.isAssignableFrom(
			parameter.getClass(  ) )) {
      cf = null;
    } else if (TextListParam.class.isAssignableFrom(
			parameter.getClass(  ) )) {
      cf = new TextListParamFormatter(
		(TextListParam)parameter , m_strIndent );
    } else if (TextParam.class.isAssignableFrom( parameter.getClass(  ) )) {
      cf = new TextParamFormatter( (TextParam)parameter , m_strIndent );
    } else {
      cf = new ParameterFormatter( parameter , m_strIndent );
    }

    return cf == null ? "" : cf.toString(  );
  }

}


/* Log:
 *  0.01  2003/11/26  slh
 *        update for ValueTypeParam -> ValueParam change
 *  0.00  2003/07/02, 2003/07/09 - 2003/07/10, 2003/07/15  slh
 *        create from ParametersXMLer
 */
/*--ParametersFormatter.java------------------------------------------------*/

