/*++ComponentFormatter.java+++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.text;


import  edu.washington.cac.calendar.icalendar.Component;


/**
 * Generates formatted text of Component's contents.
 *
 * @author  slh
 * @version  0.00 2003/07/02 slh
 */
public
class  ComponentFormatter
extends  CollectibleFormatter
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  ComponentFormatter  (Component	component	)
  {
    super( component );
  }


  public
  ComponentFormatter  (Component	component	,
		       String		strIndent	)
  {
    super( component , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    Component	component	= (Component)m_collectible;

    return m_strIndent + Config.strComponentDelim + "\n" +
		new PropertiesFormatter(
			component.getProperties(  ) , m_strIndentNext ) +
		new ComponentsFormatter(
			component.getComponents(  ) , m_strIndentNext );
  }

}


/* Log:
 *  0.00  2003/07/02  slh
 *        create from ComponentXMLer
 */
/*--ComponentFormatter.java-------------------------------------------------*/
