/*++CollectionFormatter.java++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.text;


import  java.util.Iterator;

import  edu.washington.cac.calendar.icalendar.Collectible;
import  edu.washington.cac.calendar.icalendar.Collection;


/**
 * Base class for text formatters for Collection-derived classes.
 *
 * @author  slh
 * @version  0.00 2003/07/02 slh
 */
abstract public
class  CollectionFormatter
extends  CollectibleFormatter
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  CollectionFormatter  (Collection	collection	)
  {
    this( collection , null );
  }


  /*Note: this is the base constructor*/
  public
  CollectionFormatter  (Collection	collection	,
			String		strIndent	)
  {
    super( collection , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  /**
   * Return an item's value as a String.
   */
  abstract public
  String
  getString  (Collectible	collectible	);


  public
  String
  toString  (		)
  {
    Collection	collection	= (Collection)m_collectible;
    Iterator	iter;
    String	str		= "";

    if (collection != null && collection.size(  ) > 0) {
      for (iter = collection.elements(  ) ; iter.hasNext(  ) ; ) {
	str += getString( (Collectible)iter.next(  ) );
      }
    }

    return str;
  }

}


/* Log:
 *  0.00  2003/07/02  slh
 *        create from CollectionXMLer
 */
/*--CollectionFormatter.java------------------------------------------------*/
