/*++CollectibleFormatter.java+++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.text;


import  java.util.StringTokenizer;

import  edu.washington.cac.calendar.icalendar.Collectible;


/**
 * Base class for text formatters for Collectible-derived classes.
 *
 * @author  slh
 * @version  0.00 2003/07/16 slh
 */
abstract public
class  CollectibleFormatter
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  CollectibleFormatter  (Collectible	collectible	)
  {
    this( collectible , null );
  }


  /*Note: this is the base constructor*/
  public
  CollectibleFormatter  (Collectible	collectible	,
			 String		strIndent	)
  {
    if (collectible == null) {
      throw new NullPointerException(
		"CollectibleFormatter: CollectibleFormatter():" +
		" (Collectible) collectible is null" );
    }

    m_collectible = collectible;
    if (strIndent == null) {
      m_strIndent = "";
    } else {
      m_strIndent = strIndent;
      m_strIndentNext = strIndent + Config.strIndentIncr;
    }
    m_strIndentPrimary = m_strIndent +
		padText( collectible.getName(  ) +
			 Config.strNameValueSepPrimary ,
			 Config.LabelWidth );
    m_strIndentSecondary = m_strIndent + padText( "" , Config.LabelWidth );
  }


/*----------------------------------------------------------------------------
 *						Class Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  String
  padText  (String	strText	,
	    int		Length	)
  {
    StringBuffer	sb;
    int		idx;

    sb = new StringBuffer( strText );
    sb.setLength( Length );
    for (idx = strText.length(  ) ; idx < Length ; idx++) {
      /*void*/sb.setCharAt( idx , Config.chPad );
    }

    return sb.toString(  );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  /*Assert: m_collectible never null after construction*/
  protected  Collectible	m_collectible;
  /*Assert: m_strIndent never null after construction*/
  protected  String		m_strIndent;
		/* current level of indent */
  protected  String		m_strIndentNext;
		/* next level of indent */
  protected  String		m_strIndentPrimary;
		/* name and separator formatted to fixed width */
  protected  String		m_strIndentSecondary;
		 /* for when multiple values done on multiple lines */

}


/* Log:
 *  0.00  2003/07/02, 2003/07/15 - 2003/07/16  slh
 *        create from CollectibleXMLer
 */
/*--CollectibleFormatter.java-----------------------------------------------*/
