/*++PropertyDumper.java+++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.instrumentation;


import  java.util.Iterator;

import  edu.washington.cac.calendar.icalendar.Property;
import  edu.washington.cac.calendar.icalendar.TextListProp;


/**
 * Dump Property's contents.
 *
 * @author  slh
 * @version  0.00 2003/06/18 slh
 */
public
class  PropertyDumper
extends  CollectibleDumper
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  PropertyDumper  (Property	property	)
  {
    super( property , null );
  }


  public
  PropertyDumper  (Property	property	,
		   String	strIndent	)
  {
    super( property , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    Property	property	= (Property)m_collectible;
    String	strValue	= property.getString(  );
    String	strDump		= "";

    if (!TextListProp.class.isAssignableFrom( property.getClass(  ) )) {
      strDump += m_strIndent + property.getName(  ) + ":" +
		(strValue == null ? "" : strValue) + "\n";
    } else {
      strDump += TextListToString( (TextListProp)property );
    }

    strDump += new ParametersDumper(
		property.getParameters(  ) , m_strIndentNext );

    return strDump;
  }

/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  String
  TextListToString  (TextListProp	tlp	)
  {
    Iterator	iter;
    String	strDump		= "";

    strDump += m_strIndent + tlp.getName(  ) +
		(Config.bBrackets ? Config.strOpenBracket : "") + "\n";
    for (iter = tlp.getList(  ) ; iter.hasNext(  ) ; ) {
      strDump += m_strIndentNext + iter.next(  ) + "\n";
    }
    strDump += m_strIndent +
		(Config.bBrackets ? Config.strCloseBracket : "") +
		(Config.bEndTags ? tlp.getName(  ) : "" ) + "\n";

    return strDump;
  }

}


/* Log:
 *  0.00  2003/06/17 - 2003/06/18  slh
 *        create
 */
/*--PropertyDumper.java-----------------------------------------------------*/
