/*++ParameterDumper.java++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.instrumentation;


import  java.util.Iterator;

import  edu.washington.cac.calendar.icalendar.Parameter;
import  edu.washington.cac.calendar.icalendar.TextListParam;


/**
 * Dump Parameter's contents.
 *
 * @author  slh
 * @version  0.00 2003/06/18 slh
 */
public
class  ParameterDumper
extends  CollectibleDumper
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  ParameterDumper  (Parameter	parameter	)
  {
    super( parameter );
  }


  public
  ParameterDumper  (Parameter	parameter	,
		    String	strIndent	)
  {
    super( parameter , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    Parameter	parameter	= (Parameter)m_collectible;

    if (!TextListParam.class.isAssignableFrom( parameter.getClass(  ) )) {
      return m_strIndent + parameter + "\n";			/*RETURN*/
    } else {
      return TextListToString( (TextListParam)parameter );	/*RETURN*/
    }
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  String
  TextListToString  (TextListParam	tlp	)
  {
    Iterator	iter;
    String	strDump		= "";

    strDump += m_strIndent + tlp.getName(  ) +
		(Config.bBrackets ? Config.strOpenBracket : "") + "\n";
    for (iter = tlp.getList(  ) ; iter.hasNext(  ) ; ) {
      strDump += m_strIndentNext + iter.next(  ) + "\n";
    }
    strDump += m_strIndent +
		(Config.bBrackets ? Config.strCloseBracket : "") +
		(Config.bEndTags ? tlp.getName(  ) : "") + "\n";

    return strDump;
  }

}


/* Log:
 *  0.00  2003/06/17 - 2003/06/18  slh
 *        create
 */
/*--ParameterDumper.java----------------------------------------------------*/
