/*++ComponentDumper.java++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.instrumentation;


import  edu.washington.cac.calendar.icalendar.Component;


/**
 * Dump Component's contents.
 *
 * @author  slh
 * @version  0.00 2003/06/18 slh
 */
public
class  ComponentDumper
extends  CollectibleDumper
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  ComponentDumper  (Component	component	)
  {
    super( component );
  }


  public
  ComponentDumper  (Component	component	,
		    String	strIndent	)
  {
    super( component , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  toString  (		)
  {
    Component	component	= (Component)m_collectible;

    return m_strIndent + component.getName(  ) +
		(Config.bBrackets ? Config.strOpenBracket : "") + "\n" +
		new PropertiesDumper(
			component.getProperties(  ) , m_strIndentNext ) +
		new ComponentsDumper(
			component.getComponents(  ) , m_strIndentNext ) +
		m_strIndent +
		(Config.bBrackets ? Config.strCloseBracket : "") +
		(Config.bEndTags || Config.bCompEndTags
		 ? component.getName(  ) : "") + "\n";
  }

}


/* Log:
 *  0.00  2003/06/17 - 2003/06/18  slh
 *        create
 */
/*--ComponentDumper.java----------------------------------------------------*/
