/*++CollectionDumper.java+++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.instrumentation;


import  java.util.Iterator;

import  edu.washington.cac.calendar.icalendar.Collectible;
import  edu.washington.cac.calendar.icalendar.Collection;


/**
 * Dump Collection's contents.
 * Base class for dumpers for Collection-derived classes.
 *
 * @author  slh
 * @version  0.00 2003/06/18 slh
 */
abstract public
class  CollectionDumper
extends  CollectibleDumper
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  CollectionDumper  (Collection	collection	)
  {
    this( collection , null );
  }


  /*Note: this is the base constructor*/
  public
  CollectionDumper  (Collection	collection	,
		     String	strIndent	)
  {
    super( collection , strIndent );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  /**
   * Return an item's value as a String.
   */
  abstract public
  String
  getString  (Collectible	collectible	);


  public
  String
  toString  (		)
  {
    Collection	collection	= (Collection)m_collectible;
    Iterator	iter;
    String	str		= "";

    if (collection != null && collection.size(  ) > 0) {
      str += m_strIndent + collection.getName(  ) +
		(Config.bBrackets ? Config.strOpenBracket : "") + "\n";
      for (iter = collection.elements(  ) ; iter.hasNext(  ) ; ) {
	str += getString( (Collectible)iter.next(  ) );
      }
      str += m_strIndent +
		(Config.bBrackets ? Config.strCloseBracket : "") +
		(Config.bEndTags ? collection.getName(  ) : "") + "\n";
    }

    return str;
  }

}


/* Log:
 *  0.00  2003/06/17 - 2003/06/18  slh
 *        create
 */
/*--CollectionDumper.java---------------------------------------------------*/
