/*++CollectibleDumper.java++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar.instrumentation;


import  edu.washington.cac.calendar.icalendar.Collectible;


/**
 * Dump Collectible's contents.
 * Base class for dumpers for Collectible-derived classes.
 *
 * @author  slh
 * @version  0.00 2003/06/17 slh
 */
abstract public
class  CollectibleDumper
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  CollectibleDumper  (Collectible	collectible	)
  {
    this( collectible , null );
  }


  /*Note: this is the base constructor*/
  public
  CollectibleDumper  (Collectible	collectible	,
		      String		strIndent	)
  {
    if (collectible == null) {
      throw new NullPointerException(
		"CollectibleDumper: CollectibleDumper():" +
		" (Collectible) collectible is null" );
    }

    m_collectible = collectible;
    if (strIndent == null) {
      m_strIndent = "";
    } else {
      m_strIndent = strIndent;
      m_strIndentNext = strIndent + Config.strIndentIncr;
    }
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  /*Assert: m_collectible never null after construction*/
  protected  Collectible	m_collectible;
  /*Assert: m_strIndent never null after construction*/
  protected  String		m_strIndent;
  protected  String		m_strIndentNext;

}


/* Log:
 *  0.00  2003/06/17  slh
 *        create
 */
/*--CollectibleDumper.java--------------------------------------------------*/
