/*++XProp.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar x-prop property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.8.1 [2445]
 *   occurs:	0+
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *   params:	xparam(0+), LANGUAGE(0-1)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/04/22 slh
 */
public
class  XProp
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create an x property of supplied name, unset.
   */
  public
  XProp  (String	strName		)
  {
    super( strName );
  }


  /**
   * Create an x property of supplied name set to supplied value.
   */
  public
  XProp  (String	strName		,
	  String	strValue	)
  {
    super( strName , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_X;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( LanguageParam.class );
  }

}


/* Log:
 *  0.11  2003/01/21, 2003/04/15, 2003/04/22  slh
 *        (new year, new version...)
 *        getCalendarName()
 *        redo constructors
 *        configProperty(); drop addParameter()
 *  0.10  2002/10/29  slh
 *        redid constructors
 *  0.01  2001/05/15 - 2001/05/16  slh
 *        UnsupProp -> TextProp
 *  0.00  2001/05/02  slh
 *        create
 */
/*--XProp.java--------------------------------------------------------------*/
