/*++XParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * iCalendar x parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2 [2445]
 *   occurs:	---
 *   datatypes:	TEXT (1+)
 *   default:	---
 *   allowed:	---
 *</PRE>
 *
 * @author  slh
 * @version  0.02 2003/04/22 slh
 */
public
class  XParam
extends  TextListParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create an x parameter of supplied name, unset.
   */
  public
  XParam  (String	strName		)
  {
    super( strName );
  }


  /**
   * Create an x parameter of supplied name set to supplied value.
   */
  public
  XParam  (String	strName		,
	   String	strValue	)
  {
    super( strName , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strParam_X;
  }

}


/* Log:
 *  0.02  2003/01/22, 2003/04/22  slh
 *        getCalendarName()
 *        redo constructors
 *  0.01  2001/05/16  slh
 *        UnsupProp -> TextListProp
 *  0.00  2001/05/02  slh
 *        create
 */
/*--XParam.java-------------------------------------------------------------*/
