/*++XComp.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar x component.
 *
 * <PRE>	<!-- for alignment purposes -->&nbsp;
 * ``
 * x-comp     = "BEGIN" ":" x-name CRLF
 *              1*contentline
 *              "END" ":" x-name CRLF
 * ''
 * Taking this to mean contents arranged as components and properties,
 * though it does not necessarily mean that.
 *
 *   section:	4.6 [2445]
 *   props:	any
 *   comps:	any
 * </PRE>
 *
 * @author  slh
 * @version  0.11 2003/04/22 slh
 */
public
class  XComp
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create an x component of supplied name, unset.
   */
  public
  XComp  (String	strName		)
  {
    super( strName );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strComp_X;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (         )
  {
    /* ``
     * x-comp     = "BEGIN" ":" x-name CRLF
     *              1*contentline
     *              "END" ":" x-name CRLF
     * ''
     */
    return m_properties != null && m_properties.size(  ) > 0 ||
		m_components != null && m_components.size(  ) > 0;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configComponent  (		)
  {
    m_vCompZeroPlus = new Vector(  );
    m_vCompZeroPlus.add( Component.class );

    m_vPropZeroPlus = new Vector(  );
    m_vPropZeroPlus.add( Property.class );
  }

}


/* Log:
 *  0.20  2003/01/21 - 2003/01/22, 2003/04/22  slh
 *        (new year, new version...)
 *        use base classes for allowed member lists
 *        getCalendarName()
 *        configComponent(); list all; drop addComponent(), addProperty()
 *        redo constructors
 *  0.10  2002/11/04, 2002/11/13  slh
 *        derive from Component (rather than UnsupComp)
 *  0.00  2001/05/09  slh
 *        create
 */
/*--XComp.java--------------------------------------------------------------*/
