/*++Version.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;



/**
 * ICalendar VERSION property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.7.4
 *   occurs:	1 (VCALENDAR)
 *   datatypes:	TEXT (1-2)
 *   default:	---
 *   allowed:	iana-token (;-separated)
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2002/11/06 slh
 */
public
class  Version
extends  TextListProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a VERSION property unset.
   */
  /* this is the base constructor */
  public
  Version  (		)
  {
    super( Names.strProp_Version ,
	   mc_strDelimiter , mc_MinElement , mc_MaxElement );
  }


  /**
   * Create a VERSION property set to indicated value.
   */
  public
  Version  (String	strValues	)
  {
    this(  );

    try {
      /*void*/set( strValues );
    } catch (Exception	e	) {
      throw new IllegalArgumentException( e.getLocalizedMessage(  ) );
    }
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  String	mc_strCurrentVersion	= "2.0";
  final static public  String	mc_strDelimiter		= ";";
  final static public  int	mc_MinElement		= 1;
  final static public  int	mc_MaxElement		= 2;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    Version	version		= new Version( "1.0" );

    try {
      /*void*/System.out.println( version );
      /*void*/version.addTexts( "2.0" );
      /*void*/System.out.println( version );

      /*void*/System.out.println(
		"NOTE: should throw TooManyValuesException:" );
      /*void*/version.addTexts( "3.0" );
      /*void*/System.out.println( version );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
  }

}


/* Log:
 *  0.10  2002/11/06  slh
 *        derive from TextListProp (rather than TextProp)
 *  0.00  2001/04/24 - 2001/04/25, 2001/05/08  slh
 *        create
 */
/*--Version.java------------------------------------------------------------*/
