/*++ValueParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar VALUE parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2.20 [2445]
 *   occurs:	various
 *   datatypes:	TEXT (1)
 *   default:	depends on property
 *   allowed:	"BINARY", "BOOLEAN", "CAL-ADDRESS", "DATE", "DATE-TIME",
 *		"DURATION", "FLOAT", "INTEGER", "PERIOD", "RECUR", "TEXT",
 *		"TIME", "URI", "UTC-OFFSET", iana-token, x-name
 *</PRE>
 *
 * @author  slh
 * @version  0.20 2003/10/29 slh
 */
public
class  ValueParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a VALUE parameter, unset.
   */
  public
  ValueParam  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a VALUE parameter set to supplied value.
   */
  public
  ValueParam  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a VALUE parameter set to supplied value.
   */
  public
  ValueParam  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }

/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strParam_Value;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumParam.configEnum()
    which is called in EnumParam.EnumParam(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( BINARY ) , Names.strValue_Binary );
    m_hmValue.put( new Integer( BOOLEAN ) , Names.strValue_Boolean );
    m_hmValue.put( new Integer( CALADDRESS ) , Names.strValue_CalAddress );
    m_hmValue.put( new Integer( DATE ) , Names.strValue_Date );
    m_hmValue.put( new Integer( DATETIME ) , Names.strValue_DateTime );
    m_hmValue.put( new Integer( DURATION ) , Names.strValue_Duration );
    m_hmValue.put( new Integer( FLOAT ) , Names.strValue_Float );
    m_hmValue.put( new Integer( INTEGER ) , Names.strValue_Integer );
    m_hmValue.put( new Integer( PERIOD ) , Names.strValue_Period );
    m_hmValue.put( new Integer( RECUR ) , Names.strValue_Recur );
    m_hmValue.put( new Integer( TEXT ) , Names.strValue_Text );
    m_hmValue.put( new Integer( TIME ) , Names.strValue_Time );
    m_hmValue.put( new Integer( URI ) , Names.strValue_URI );
    m_hmValue.put( new Integer( UTCOFFSET ) , Names.strValue_UTCOffset );
    m_hmValue.put( new Integer( XNAME ) , null );
    m_hmValue.put( new Integer( IANATOKEN ) , null );

    /* no default */
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	BINARY		=  1;
  final static public  int	BOOLEAN		=  2;
  final static public  int	CALADDRESS	=  3;
  final static public  int	DATE		=  4;
  final static public  int	DATETIME	=  5;
  final static public  int	DURATION	=  6;
  final static public  int	FLOAT		=  7;
  final static public  int	INTEGER		=  8;
  final static public  int	PERIOD		=  9;
  final static public  int	RECUR		= 10;
  final static public  int	TEXT		= 11;
  final static public  int	TIME		= 12;
  final static public  int	URI		= 13;
  final static public  int	UTCOFFSET	= 14;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    ValueParam	vp		= new ValueParam( "binary" );

    /*void*/System.out.println( vp );

    try {
      /*void*/vp.set( Names.strValue_Date );
      /*void*/System.out.println( vp );

      /*void*/vp.set( ValueParam.TIME );
      /*void*/System.out.println( vp );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( vp.get(  ) );
    /*void*/System.out.println( vp.getEnum(  ) );

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/vp.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/vp.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( vp );
  }

}


/* Log:
 *  0.20  2003/10/29  slh
 *        ValueTypeParam -> ValueParam (to make consistant w/rest)
 *  0.11  2003/10/29  slh
 *        sync with current paradigms
 *  0.10  2002/12/02  slh
 *        use new, table-driven EnumParam
 *          (which also corrects bug of values not being case-insensitive)
 *  0.00  2002/03/05 - 2002/03/06  slh
 *        create from Class
 */
/*--ValueParam.java---------------------------------------------------------*/
