/*++VTodo.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar VTODO component.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.6.2 [2445]
 *   occurs:	VCALENDAR (0+)
 *   comps:	VALARM (0+)
 *   props:	CLASS(0-1), COMPLETED(0-1), CREATED(0-1),
 *      	DESCRIPTION(0-1), DTSTAMP(0-1),
 *		DTSTART(0-1), GEO(0-1),
 *      	LAST-MODIFIED(0-1), LOCATION(0-1), ORGANIZER(0-1),
 *      	PERCENT-COMPLETE(0-1), PRIORITY(0-1), RECURRENCE-ID(0-1),
 *      	SEQUENCE(0-1), STATUS(0-1),
 *		SUMMARY(0-1), UID(0-1), URL(0-1),
 *      	*DUE(0-1), DURATION(0-1)*,
 *      	ATTACH(0+), ATTENDEE(0+),
 *		CATEGORIES(0+), COMMENT(0+), CONTACT(0+),
 *		EXDATE(0+), EXRULE(0+),
 *		REQUEST-STATUS(0+), RELATED-TO(0+), RESOURCES(0+),
 *		RDATE(0+), RRULE(0+),
 *      	x-prop(0+)
 *
 * * DUE and DURATION are mutually exclusive
 *</PRE>
 *
 * @author  slh
 * @version  0.02 2003/10/28 slh
 */
public
class  VTodo
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  VTodo  (		)
  {
    super( getCalendarName(  ) );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strComp_VTodo;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    DTStart	dtstart;
    Due		due;

    /* if not otherwise complete... */
    if (!super.isComplete(  )) {
      return false;						/*RETURN*/
    }

    dtstart = ((DTStart)m_properties.getFirst( DTStart.class ));
    due = ((Due)m_properties.getFirst( Due.class ));

    /* if start and end present and
       either start is after end or start is a date but end is not... */
    if (dtstart != null && due != null &&
	(dtstart.get(  ).after( due.get(  ) ) ||
	 dtstart.getType(  ) == TimeProp.DATE &&
	 due.getType(  ) != TimeProp.DATE)) {
      return false;						/*RETURN*/
    }

    return true;						/*RETURN*/
  }


  public
  void
  addProperty  (Property	property	)
  throws ICalendarException
  {
    if (property == null) {
      throw new NullPointerException( getName(  ) + ": addProperty()" +
		": property (Property) is null" );
    }

    /* if property is a DUE or DURATION and either is already present... */
    if ((Due.class.isAssignableFrom( property.getClass(  ) ) ||
	 Duration.class.isAssignableFrom( property.getClass(  ) )) &&
	(0 != m_properties.getCount( Due.class ) ||
	 0 != m_properties.getCount( Duration.class ))) {
      throw new InvalidPropertyException( getName(  ) + ": addProperty()" +
		": only one instance of either DUE or DURATION allowed" );
    }

    /*void*/super.addProperty( property );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configComponent  (		)
  {
    m_vCompZeroPlus = new Vector(  );
    /*void*/m_vCompZeroPlus.add( VAlarm.class );

    m_vPropZeroOne = new Vector(  );
    /*void*/m_vPropZeroOne.add( Class.class );
    /*void*/m_vPropZeroOne.add( Completed.class );
    /*void*/m_vPropZeroOne.add( Created.class );
    /*void*/m_vPropZeroOne.add( Description.class );
    /*void*/m_vPropZeroOne.add( DTStamp.class );
    /*void*/m_vPropZeroOne.add( DTStart.class );
    /*void*/m_vPropZeroOne.add( Geo.class );
    /*void*/m_vPropZeroOne.add( LastModified.class );
    /*void*/m_vPropZeroOne.add( Location.class );
    /*void*/m_vPropZeroOne.add( Organizer.class );
    /*void*/m_vPropZeroOne.add( PercentComplete.class );
    /*void*/m_vPropZeroOne.add( Priority.class );
    /*void*/m_vPropZeroOne.add( RecurrenceId.class );
    /*void*/m_vPropZeroOne.add( Sequence.class );
    /*void*/m_vPropZeroOne.add( Status.class );
    /*void*/m_vPropZeroOne.add( Summary.class );
    /*void*/m_vPropZeroOne.add( UID.class );
    /*void*/m_vPropZeroOne.add( URL.class );
    /*void*/m_vPropZeroOne.add( Due.class );
    /*void*/m_vPropZeroOne.add( Duration.class );

    m_vPropZeroPlus = new Vector(  );
    /*void*/m_vPropZeroPlus.add( Attach.class );
    /*void*/m_vPropZeroPlus.add( Attendee.class );
    /*void*/m_vPropZeroPlus.add( Categories.class );
    /*void*/m_vPropZeroPlus.add( Comment.class );
    /*void*/m_vPropZeroPlus.add( Contact.class );
    /*void*/m_vPropZeroPlus.add( ExDate.class );
    /*void*/m_vPropZeroPlus.add( ExRule.class );
    /*void*/m_vPropZeroPlus.add( RequestStatus.class );
    /*void*/m_vPropZeroPlus.add( RelatedTo.class );
    /*void*/m_vPropZeroPlus.add( Resources.class );
    /*void*/m_vPropZeroPlus.add( RDate.class );
    /*void*/m_vPropZeroPlus.add( RRule.class );
    /*void*/m_vPropZeroPlus.add( XProp.class );
  }

}


/* Log:
 *  0.02  2003/10/28  slh
 *        isComplete(): add
 *        addProperty(): use isAssignableFrom()
 *  0.01  2003/04/16  slh
 *        (new year, new version...)
 *        implement: derive from Component (instead of UnsupComp)
 *        getCalendarName(), configComponent(), addProperty()
 *  0.00  2002/11/05  slh
 *        create
 */
/*--VTodo.java--------------------------------------------------------------*/
