/*++VJournal.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar VJOURNAL component.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.6.3 [2445]
 *   occurs:	0+
 *   comps:	none
 *   props:	CLASS(0-1), CREATED(0-1),
 *		DESCRIPTION(0-1), DTSTART(0-1), DTSTAMP(0-1),
 *		LAST-MODIFIED(0-1), ORGANIZER(0-1), RECURRENCE-ID(0-1),
 *		SEQUENCE(0-1), STATUS(0-1),
 *		SUMMARY(0-1), UID(0-1), URL(0-1),
 *		ATTACH(0+), ATTENDEE(0+), CATEGORIES(0+), COMMENT(0+),
 *		CONTACT(0+), EXDATE(0+), EXRULE(0+),
 *		RELATED-TO(0+), RDATE(0+),
 *		RRULE(0+), REQUEST-STATUS(0+),
 *		x-prop(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.01 2003/04/16 slh
 */
public
class  VJournal
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  VJournal  (		)
  {
    super( getCalendarName(  ) );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strComp_VJournal;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configComponent  (		)
  {
    m_vPropZeroOne = new Vector(  );
    /*void*/m_vPropZeroOne.add( Class.class );
    /*void*/m_vPropZeroOne.add( Created.class );
    /*void*/m_vPropZeroOne.add( Description.class );
    /*void*/m_vPropZeroOne.add( DTStart.class );
    /*void*/m_vPropZeroOne.add( DTStamp.class );
    /*void*/m_vPropZeroOne.add( LastModified.class );
    /*void*/m_vPropZeroOne.add( Organizer.class );
    /*void*/m_vPropZeroOne.add( RecurrenceId.class );
    /*void*/m_vPropZeroOne.add( Sequence.class );
    /*void*/m_vPropZeroOne.add( Status.class );
    /*void*/m_vPropZeroOne.add( Summary.class );
    /*void*/m_vPropZeroOne.add( UID.class );
    /*void*/m_vPropZeroOne.add( URL.class );

    m_vPropZeroPlus = new Vector(  );
    /*void*/m_vPropZeroPlus.add( Attach.class );
    /*void*/m_vPropZeroPlus.add( Attendee.class );
    /*void*/m_vPropZeroPlus.add( Categories.class );
    /*void*/m_vPropZeroPlus.add( Comment.class );
    /*void*/m_vPropZeroPlus.add( Contact.class );
    /*void*/m_vPropZeroPlus.add( ExDate.class );
    /*void*/m_vPropZeroPlus.add( ExRule.class );
    /*void*/m_vPropZeroPlus.add( RelatedTo.class );
    /*void*/m_vPropZeroPlus.add( RDate.class );
    /*void*/m_vPropZeroPlus.add( RRule.class );
    /*void*/m_vPropZeroPlus.add( RequestStatus.class );
    /*void*/m_vPropZeroPlus.add( XProp.class );
  }

}


/* Log:
 *  0.10  2003/04/16  slh
 *        (new year, new version...)
 *        implement: derive from Component (instead of UnsupComp)
 *        getCalendarName(), configComponent()
 *  0.00  2002/11/05  slh
 *        create
 */
/*--VJournal.java-----------------------------------------------------------*/
