/*++VFreeBusy.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * ICalendar VFREEBUSY component.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.6.4 [2445]
 *   occurs:	VCALENDAR (0+)
 *   comps:	none
 *   props:	CONTACT(0-1), DTSTART(0-1), DTEND(0-1), DURATION(0-1),
 *      	DTSTAMP(0-1),
 *		ORGANIZER(0-1), UID(0-1), URL(0-1),
 *      	ATTENDEE(0+), COMMENT(0+), FREEBUSY(0+), REQUEST-STATUS(0+),
 *     		x-prop(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/04/23 slh
 */
public
class  VFreeBusy
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  VFreeBusy  (		)
  {
    super( getCalendarName(  ) );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strComp_VFreeBusy;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configComponent  (		)
  {
    m_vPropZeroOne = new Vector(  );
    /*void*/m_vPropZeroOne.add( Contact.class );
    /*void*/m_vPropZeroOne.add( DTStart.class );
    /*void*/m_vPropZeroOne.add( DTEnd.class );
    /*void*/m_vPropZeroOne.add( Duration.class );
    /*void*/m_vPropZeroOne.add( DTStamp.class );
    /*void*/m_vPropZeroOne.add( Organizer.class );
    /*void*/m_vPropZeroOne.add( UID.class );
    /*void*/m_vPropZeroOne.add( URL.class );

    m_vPropZeroPlus = new Vector(  );
    /*void*/m_vPropZeroPlus.add( Attendee.class );
    /*void*/m_vPropZeroPlus.add( Comment.class );
    /*void*/m_vPropZeroPlus.add( FreeBusy.class );
    /*void*/m_vPropZeroPlus.add( RequestStatus.class );
    /*void*/m_vPropZeroPlus.add( XProp.class );
  }

}


/* Log:
 *  0.10  2003/04/23  slh
 *        derive from Component (instead of UnsupComp)
 *        configComponent()
 *        getCalendarName()
 *  0.00  2002/11/05  slh
 *        create
 */
/*--VFreeBusy.java----------------------------------------------------------*/
