/*++VEvent.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar VEVENT component.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.6.1 [2445]
 *   occurs:	VCALENDAR (0+)
 *   comps:	VALARM (0+)
 *   props:	CLASS(0-1), CREATED(0-1), DESCRIPTION(0-1), DTSTART(0-1),
 *		GEO(0-1), LAST-MODIFIED(0-1), LOCATION(0-1), ORGANIZER(0-1),
 *		PRIORITY(0-1), DTSTAMP(0-1), SEQUENCE(0-1), STATUS(0-1),
 *		SUMMARY(0-1), TRANSP(0-1), UID(0-1), URL(0-1),
 *		RECURRENCE-ID(0-1),
 *		*DTEND(0-1), DURATION(0-1)*,
 *		ATTACH(0+), ATTENDEE(0+), CATEGORIES(0+), COMMENT(0+),
 *		CONTACT(0+), EXDATE(0+), EXRULE(0+), REQUEST-STATUS(0+),
 *		RELATED-TO(0+), RESOURCES(0+), RDATE(0+), RRULE(0+),
 *		x-prop(0+)
 *
 * * DTEND and DURATION are mutually exclusive
 *</PRE>
 *
 * @author  slh
 * @version  0.11 2003/10/28 slh
 */
public
class  VEvent
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  VEvent  (		)
  {
    super( getCalendarName(  ) );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strComp_VEvent;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    DTStart	dtstart;
    DTEnd	dtend;

    /* if not otherwise complete... */
    if (!super.isComplete(  )) {
      return false;						/*RETURN*/
    }

    dtstart = ((DTStart)m_properties.getFirst( DTStart.class ));
    dtend = ((DTEnd)m_properties.getFirst( DTEnd.class ));

    /* if start and end present and
       either start is after end or start is a date but end is not... */
    if (dtstart != null && dtend != null &&
	(dtstart.get(  ).after( dtend.get(  ) ) ||
	 dtstart.getType(  ) == TimeProp.DATE &&
	 dtend.getType(  ) != TimeProp.DATE)) {
      return false;						/*RETURN*/
    }

    return true;						/*RETURN*/
  }


  public
  void
  addProperty  (Property	property	)
  throws ICalendarException
  {
    if (property == null) {
      throw new NullPointerException( getName(  ) + ": addProperty()" +
		": property (Property) is null" );
    }

    /* if property is a DTEND or DURATION and either is already present... */
    if ((DTEnd.class.isAssignableFrom( property.getClass(  ) ) ||
	 Duration.class.isAssignableFrom( property.getClass(  ) )) &&
	(0 != m_properties.getCount( DTEnd.class ) ||
	 0 != m_properties.getCount( Duration.class ))) {
      throw new InvalidPropertyException( getName(  ) + ": addProperty()" +
		": only one instance of either DTEND or DURATION allowed" );
    }

    /*void*/super.addProperty( property );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configComponent  (		)
  {
    m_vCompZeroPlus = new Vector(  );
    /*void*/m_vCompZeroPlus.add( VAlarm.class );

    m_vPropZeroOne = new Vector(  );
    /*void*/m_vPropZeroOne.add( Class.class );
    /*void*/m_vPropZeroOne.add( Created.class );
    /*void*/m_vPropZeroOne.add( Description.class );
    /*void*/m_vPropZeroOne.add( DTStart.class );
    /*void*/m_vPropZeroOne.add( Geo.class );
    /*void*/m_vPropZeroOne.add( LastModified.class );
    /*void*/m_vPropZeroOne.add( Location.class );
    /*void*/m_vPropZeroOne.add( Organizer.class );
    /*void*/m_vPropZeroOne.add( Priority.class );
    /*void*/m_vPropZeroOne.add( DTStamp.class );
    /*void*/m_vPropZeroOne.add( Sequence.class );
    /*void*/m_vPropZeroOne.add( Status.class );
    /*void*/m_vPropZeroOne.add( Summary.class );
    /*void*/m_vPropZeroOne.add( Transp.class );
    /*void*/m_vPropZeroOne.add( UID.class );
    /*void*/m_vPropZeroOne.add( URL.class );
    /*void*/m_vPropZeroOne.add( RecurrenceId.class );
    /*void*/m_vPropZeroOne.add( DTEnd.class );
    /*void*/m_vPropZeroOne.add( Duration.class );

    m_vPropZeroPlus = new Vector(  );
    /*void*/m_vPropZeroPlus.add( Attach.class );
    /*void*/m_vPropZeroPlus.add( Attendee.class );
    /*void*/m_vPropZeroPlus.add( Categories.class );
    /*void*/m_vPropZeroPlus.add( Comment.class );
    /*void*/m_vPropZeroPlus.add( Contact.class );
    /*void*/m_vPropZeroPlus.add( ExDate.class );
    /*void*/m_vPropZeroPlus.add( ExRule.class );
    /*void*/m_vPropZeroPlus.add( RequestStatus.class );
    /*void*/m_vPropZeroPlus.add( RelatedTo.class );
    /*void*/m_vPropZeroPlus.add( Resources.class );
    /*void*/m_vPropZeroPlus.add( RDate.class );
    /*void*/m_vPropZeroPlus.add( RRule.class );
    /*void*/m_vPropZeroPlus.add( XProp.class );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void
  main  (String	argv[]	)
  {
    VEvent	vevent		= new VEvent(  );
    DTStart	dtstart		= new DTStart(  );
    DTEnd	dtend		= new DTEnd(  );

    /*void*/System.out.println( vevent.isComplete(  ) );
    /*void*/System.out.println( vevent );

    try {
      /*void*/vevent.addProperty( dtstart );
      /*void*/vevent.addProperty( dtend );
      /*void*/System.out.println( vevent.isComplete(  ) );
      /*void*/System.out.println( vevent );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      /*void*/dtstart.set( "20031028T120000" );
      /*void*/dtend.set( "20031028T110000" );
      /*void*/System.out.println( vevent.isComplete(  ) );
      /*void*/System.out.println( vevent );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      /*void*/dtstart.set( "20031030" );
      /*void*/System.out.println( vevent.isComplete(  ) );
      /*void*/System.out.println( vevent );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      /*void*/dtstart.set( "20031028T120000" );
      /*void*/dtend.set( "20031028T130000" );
      /*void*/System.out.println( vevent.isComplete(  ) );
      /*void*/System.out.println( vevent );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
  }

}


/* Log:
 *  0.11  2003/10/28  slh
 *        isComplete(): add
 *        addProperty(): use isAssignableFrom()
 *  0.10  2003/02/12, 2003/02/18, 2003/04/21  slh
 *        more or less complete redo to conform with current patterns
 *  0.00  2001/04/24, 2001/05/01, 2001/05/09  slh
 *        create
 */
/*--VEvent.java-------------------------------------------------------------*/
