/*++VAlarm.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar VALARM component.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.6.6 [2445]
 *   occurs:	VEVENT, VTODO (0+)
 *   comps:	---
 *   props:	vary by ACTION value
 *   aggregate	ACTION(1), TRIGGER(1),
 *		*DURATION(0-1), REPEAT(0-1)*, DESCRIPTION(0-1), SUMMARY(0-1),
 *		ATTENDEE(0+),
 *		ATTACH(0+), x-prop(0+)
 *   common	ACTION(1), TRIGGER(1),
 *		*DURATION(0-1), REPEAT(0-1)*,
 *		x-prop(0+)
 *   AUDIO	ATTACH((0-1)
 *   DISPLAY	DESCRIPTION(1)
 *   EMAIL	DESCRIPTION(1), SUMMARY(1),
 *		ATTENDEE(1+),
 *		ATTACH(0+)
 *   PROCEDURE	ATTACH(1),
 *		DESCRIPTION(0-1),
 *
 * *either both or neither of DURATION/REPEAT must appear
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/10/28 slh
 */
public
class  VAlarm
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  VAlarm  (		)
  {
    super( getCalendarName(  ) );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strComp_VAlarm;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    if (!super.isComplete(  )) {
      return false;						/*RETURN*/
    }

    /* if DURATION and REPEAT are not both either present or absent... */
    if (0 == m_properties.getCount( Duration.class ) ^
	0 == m_properties.getCount( Repeat.class )) {
      return false;						/*RETURN*/
    }

    switch (((Action)m_properties.getFirst( Action.class )).getEnum(  )) {
    case Action.AUDIO:
      if (1 < m_properties.getCount( Attach.class )) {
	return false;						/*RETURN*/
      }
      if (0 != m_properties.getCount( Summary.class ) ||
	  0 != m_properties.getCount( Description.class ) ||
	  0 != m_properties.getCount( Attendee.class )) {
	return false;						/*RETURN*/
      }
      break;
    case Action.DISPLAY:
      if (1 != m_properties.getCount( Description.class )) {
	return false;						/*RETURN*/
      }
      if (0 != m_properties.getCount( Summary.class ) ||
	  0 != m_properties.getCount( Attendee.class ) ||
	  0 != m_properties.getCount( Attach.class )) {
	return false;						/*RETURN*/
      }
      break;
    case Action.EMAIL:
      if (1 != m_properties.getCount( Description.class )) {
	return false;						/*RETURN*/
      }
      /* SUMMARY, ATTENDEE, ATTACH aggregate constraints same as for EMAIL */
      break;
    case Action.PROCEDURE:
      if (1 != m_properties.getCount( Attach.class )) {
	return false;						/*RETURN*/
      }
      /* DESCRIPTION aggregate constraint same as for EMAIL */
      if (0 != m_properties.getCount( Summary.class ) ||
	  0 != m_properties.getCount( Attendee.class )) {
	return false;						/*RETURN*/
      }
      break;
    default:
      break;
    }

    return true;						/*RETURN*/
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configComponent  (		)
  {
    m_vPropOne = new Vector(  );
    /*void*/m_vPropOne.add( Action.class );
    /*void*/m_vPropOne.add( Trigger.class );

    m_vPropZeroOne = new Vector(  );
    /*void*/m_vPropZeroOne.add( Duration.class );
    /*void*/m_vPropZeroOne.add( Repeat.class );
    /*void*/m_vPropZeroOne.add( Description.class );
    /*void*/m_vPropZeroOne.add( Summary.class );

    m_vPropZeroPlus = new Vector(  );
    /*void*/m_vPropZeroPlus.add( Attendee.class );
    /*void*/m_vPropZeroPlus.add( Attach.class );
    /*void*/m_vPropZeroPlus.add( XProp.class );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static
  void  main  (String	argv[]	)
  {
    VAlarm	valarm;

    valarm = new VAlarm(  );
    /*void*/System.out.println( valarm.isComplete(  ) );
    /*void*/System.out.println( valarm );

    try {
      /*void*/valarm.addProperty( new Action( Action.AUDIO ) );
      /*void*/valarm.addProperty( new Trigger( "PT0M" ) );
      /*void*/System.out.println( valarm.isComplete(  ) );
      /*void*/System.out.println( valarm );

      /*void*/valarm.addProperty( new Duration(  ) );
      /*void*/valarm.addProperty( new Repeat( 3 ) );
      /*void*/System.out.println( valarm.isComplete(  ) );
      /*void*/System.out.println( valarm );

      valarm = new VAlarm(  );
      /*void*/valarm.addProperty( new Action( Action.EMAIL ) );
      /*void*/valarm.addProperty( new Trigger( "PT0M" ) );
      /*void*/valarm.addProperty( new Description( "desc" ) );
      /*void*/valarm.addProperty( new Summary( "summ" ) );
      /*void*/valarm.addProperty( new Attendee( "mailto:me@here.now" ) );
      /*void*/System.out.println( valarm.isComplete(  ) );
      /*void*/System.out.println( valarm );
    } catch (ICalendarException	e	) {
      /*void*/System.err.println( e.getLocalizedMessage(  ) );
    }
  }

}


/* Log:
 *  0.10  2003/10/07 - 2003/10/08, 2003/10/28  slh
 *        real attempt
 *  0.00  2001/05/09  slh
 *        create
 */
/*--VAlarm.java-------------------------------------------------------------*/
