/*++Utilities.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/* Note: update log section too */
/**
 * Utilities related to iCalendar data.
 *
 * @author  slh
 * @version  0.04 2003/09/24 slh
 */
abstract public
class  Utilities
{

/*----------------------------------------------------------------------------
 *						Public Methods
 *--------------------------------------------------------------------------*/
/*-------------------------------------- Miscellaneous			*/

  /**
   * Splits a numeric string into Integers.
   *
   * @exception NumberFormatException
   * if a field was not interprettable as an integer.
   */
  static public
  int[]  splitNumber  (String	strSource	,
		       int[]	aiField		)
  /* NumberFormatException */
  {
    int		cursor, width, length;
    int		iValue;
    int[]	aiValue;
    int		idx;

    length = strSource.length(  );
    aiValue = new int[length];
    cursor = 0;
    idx = 0;
    do {
      width = aiField[ idx ];

      if (cursor + width > length) {
	width = length - cursor;
      }

      iValue = Integer.parseInt(
		strSource.substring( cursor , cursor + width ) );
      aiValue[idx] = iValue;

      cursor += width;
      idx++;
    } while (cursor < length && idx < aiField.length);

    return aiValue; 
  }


/*-------------------------------------- Encoding/Decoding		*/

  /**
   * Quoted-printable encodes, line folds and MIME encapsulates.
   */
  static public
  String  encode  (String	strUnencoded	)
  {
    String	strEncoded	= strUnencoded;

    /*Note: each of these checks for null*/
    strEncoded = foldLines( strEncoded );
    strEncoded = encodeQP( strEncoded );
    strEncoded = encodeMime( strEncoded , null , true , null );

    return strEncoded;
  }


  /**
   * Quoted-printable encodes, line folds and mime encapsulates.
   */
  static public
  String  encode  (Object	object	)
  {
    return encode( object.toString(  ) );
  }


  /**
   * MIME extracts, line unfolds and quoted-printable decodes.
   */
  static public
  String  decode  (String	strEncoded	)
  {
    String	strDecoded	= strEncoded;

    /*Note: each of these checks for null*/
    strDecoded = decodeMime( strDecoded );
    strDecoded = decodeQP( strDecoded );
    strDecoded = unfoldLines( strDecoded );

    return strDecoded;
  }


  /**
   * Encapsulate in MIME.
   *
   * @param  strContent		content to encapsulate
   * @param  strCharset		character set of strContent
   * @param  bQP		set Content-Transfer-Encoding header
   *				to quoted-printable
   * @param  strFilename	filename for Content-Disposition header
   *
   * @return  encapsulated content
   */
  static public
  String  encodeMime  (String	strContent	,
		       String	strCharset	,
		       boolean	bQP		,
		       String	strFilename	)
  {
//???
    return
	"Mime-Version: 1.0\r\n" +
	"Content-Type: text/calendar" +
	(strCharset == null ? "" : "; charset=" + strCharset + "\r\n") +
	(!bQP ? "" : "Content-Transfer-Encoding: quoted-printable\r\n") +
	(strFilename == null
	 ? ""
	 : "Content-Disposition: attachment; filename=\"" +
	   strFilename + "\"\r\n") +
	"\r\n" +
	strContent;
  }


  /**
   * Encapsulate in MIME.
   *
   * Calls encodeMime(String,String,boolean,String).
   */
  static public
  String  encodeMime  (Object	object		,
		       String	strCharset	,
		       boolean	bQP		,
		       String	strFilename	)
  {
    return encodeMime( object.toString(  ) , strCharset , bQP , strFilename );
  }


  /**
   * Extract from MIME.
   *
   * Note: this is not really correct and among other things assumes
   * a single calendar part.
   */
  static public
  String  decodeMime  (String	strIn	)
  {
//???
    int		index0, index1;
    String	strBeg	= Strings.strBegin + Strings.strValueInducer +
				Names.strVCalendar;
    String	strEnd	= Strings.strEnd + Strings.strValueInducer +
				Names.strVCalendar + Strings.strLineTerm;

    if (strIn == null) {
      throw new NullPointerException( mc_strModuleName +
		": (String) strIn is null" );
    }

    if (-1 == (index0 = strIn.indexOf( strBeg )) ||
	-1 == (index1 = strIn.lastIndexOf( strEnd ))) {
      throw new RuntimeException( mc_strModuleName +
		": begin and/or end marker could not be found" );
    }
    index1 += strEnd.length(  );

    return strIn.substring( index0 , index1 );
  }


  /**
   * Does quoted-printable encoding.
   */
  static public
  String  encodeQP  (String	strIn	)
  throws NullPointerException
  {
    StringBuffer	sbOut;
    int			ichLine;
    int			cchIn;
    int			ichIn;
    char		ch;
    int			ich, jch;

    if (strIn == null) {
      throw new NullPointerException( mc_strModuleName +
		": (String) strIn is null" );
    }

    cchIn = strIn.length(  );

    /*Note: translation will be somewhat larger*/
    sbOut = new StringBuffer( (int)(cchIn * 1.1) );
    ichLine = 0;

    /*Note: iterator may be also modified in loop*/
    for (ichIn = 0 ; ichIn < cchIn ; ichIn++) {
      ch = strIn.charAt( ichIn );
      
      /* rule (4): line breaks: does not apply to text */

      if ((int)ch == 9 || (int)ch == 32) {
      /* rule (3): white space */
	/*Note: first pass is redundant, but makes ending ich correct*/
	for (ich = ichIn ;
	     (int)strIn.charAt( ich ) == 9 || (int)strIn.charAt( ich ) == 32 ;
	     ich++) {
	  ;
	}	//Note: iterator used after loop
	for (jch = ichIn ; jch < ich - 1 ; jch++) {
	  ichLine = append( sbOut , ichLine , strIn.charAt( jch ) );
	}

	/* if ws to end of line/end of input... */
	if (ich + 1 < cchIn &&
	    strIn.charAt( ich ) == '\r' && strIn.charAt( ich + 1 ) == '\n' ||
	    ich + 1 >= cchIn) {
	  ichLine = append( sbOut , ichLine ,
			    "=" + chartohex( strIn.charAt( ich - 1 ) ) );
	} else {
	  ichLine = append( sbOut , ichLine , strIn.charAt( ich - 1 ) );
	}
	ichIn = ich - 1;	// position before last char
      } else if (33 <= (int)ch && (int)ch <= 60 ||
		 62 <= (int)ch && (int)ch <= 126) {
      /* rule (2): literal representation */
	ichLine = append( sbOut , ichLine , ch );
      } else if (ichIn + 1 < cchIn &&
		 strIn.charAt( ichIn ) == '\r' &&
		 strIn.charAt( ichIn + 1 ) == '\n') {
      /* rule (1): general 8-bit representation (line breaks) */
	ichLine = append( sbOut , ichLine , "\r\n" );
	ichIn++;
      } else {
      /* rule (1): general 8-bit representation (other chars) */
	ichLine = append( sbOut , ichLine , "=" + chartohex( ch ) );
      }
    }

    return sbOut.toString(  );
  }


  /**
   * Does quoted-printable encoding.
   */
  static public
  String  encodeQP  (Object	object	)
  throws NullPointerException
  {
    return encodeQP( object.toString(  ) );
  }


  /**
   * Does quoted-printable decoding.
   */
  static public
  String  decodeQP  (String	strIn	)
  throws NullPointerException
  {
    StringBuffer	sbOut;
    int			cchIn;
    int			ichIn;
    char		ch;

    if (strIn == null) {
      throw new NullPointerException( mc_strModuleName +
		": (String) strIn is null" );
    }

    cchIn = strIn.length(  );

    /*Note: translation will be monotonically smaller*/
    sbOut = new StringBuffer( cchIn );

    for (ichIn = 0 ; ichIn < cchIn ; ) {
      if (strIn.charAt( ichIn ) == '=') {
	ichIn++;
	/* only do translation if = followed by a hexdigit or line term */
	if (ichIn + 1 < cchIn &&
	    /*Note: as per rfc2045 decode case (1)
	      this allows the illegal lowercase hexdigits*/
	    -1 != Character.digit( strIn.charAt( ichIn ) , HEXRADIX ) &&
	    -1 != Character.digit( strIn.charAt( ichIn + 1 ) , HEXRADIX )) {
	  /*void*/sbOut.append(
		hextochar( strIn.substring( ichIn , ichIn + 2 ) ) );
	  ichIn += 2;
	} else if (ichIn + 1 < cchIn &&
		   strIn.charAt( ichIn ) == '\r' &&
		   strIn.charAt( ichIn + 1 ) == '\n') {
	  ichIn += 2;
	} else {
	  /*Note: as per rfc2045 decode case (2)
	    this allows the illegal sequence of = followed by
	    something other than the above two cases;
	    as per rfc2045 decode case (3)
	    this allows the illegal placement of =
	    as the last or second to last char*/
	  /*void*/sbOut.append( '=' );
	}
      } else {
//???
	/*Note: not as per rfc2045 decode case (4)
	  illegal control chars are being allowed*/
	/*Note: as per rfc2045 decode case (5)
	  lines over 76 octets are not being disallowed*/
	/*void*/sbOut.append( strIn.charAt( ichIn ) );
	ichIn++;
      }
    }

    return sbOut.toString(  );
  }


  /**
   * Does ICalendar line folding.
   */
  static public
  String  foldLines  (String	strIn	)
  throws NullPointerException
  {
    return fold( strIn , Strings.strLineTerm , Strings.strLineTerm + " " , 1 ,
		 CCHMAXLINEICAL );
  }


  /**
   * Does ICalendar line folding.
   */
  static public
  String  foldLines  (Object	object	)
  throws NullPointerException
  {
    return foldLines( object.toString(  ) );
  }


  /**
   * Undoes ICalendar line folding.
   */
  static public
  String  unfoldLines  (String	strIn	)
  throws NullPointerException
  {
    StringBuffer	sbOut;
    int			cchIn;
    int			ichIn;

    if (strIn == null) {
      throw new NullPointerException( mc_strModuleName +
		": (String) strIn is null" );
    }

    cchIn = strIn.length(  );

    /*Note: translation will be monotonically smaller*/
    sbOut = new StringBuffer( cchIn );

    for (ichIn = 0 ; ichIn < cchIn ; ) {
      if (ichIn + Strings.strLineTerm.length( ) + 1 - 1 < cchIn &&
	  strIn.startsWith( Strings.strLineTerm , ichIn ) &&
	  (strIn.charAt( ichIn + 2) == ' ' ||
	   strIn.charAt( ichIn + 2) == '\t')) {
	ichIn += 3;
      } else {
	/*void*/sbOut.append( strIn.charAt( ichIn ) );
	ichIn++;
      }
    }

    return sbOut.toString(  );
  }


/*----------------------------------------------------------------------------
 *						Private Methods
 *--------------------------------------------------------------------------*/

  /**
   * translates a character into the corresponding string of two hexdigits.
   */
  static private
  String  chartohex  (char	ch	)
  {
    String	str;

    str = Integer.toString( (int)ch , HEXRADIX ).toUpperCase(  );

    if (str.length(  ) == 1) {
      str = "0" + str;
    }

    return str;
  }


  /**
   * translates string of two hexdigits into corresponding character
   */
  static private
  char  hextochar  (String	str	)
  {
    char	ch;

    ch = (char)Integer.valueOf( str , HEXRADIX ).intValue(  );
    if (ch != '\u0000') {
      return ch;
    } else {
      throw new RuntimeException( mc_strModuleName +
		": invalid character code" );
    }
  }


  /**
   * Appends string, wrapping as necessary
   *
   * Assumption: str will fit on a single line and
   * if it contains any line breaks, they are at the end.
   * In current usage neither restriction is a problem.
   */
  static private
  int  append  (StringBuffer	sbOut		,
		int		ichLine		, // about to add here
		String		str		)
  {
    /*Note: CCHMAXLINEQP one less than real max
      makes it always safe to add a soft line break;
      downside of doing other (wrong) way is
      risk of outputting lines w/only a hard line break*/
//???right way is to move last char or = encoding to after soft line break

    if        (ichLine + str.length(  ) - 1 < CCHMAXLINEQP) {
      /*void*/sbOut.append( str );
      if (str.endsWith( "\r\n" )) { 
	ichLine = 0;
      } else {
	ichLine += str.length(  );
      }
    } else if (str.endsWith( "\r\n" )) {
      if (ichLine + str.length(  ) - 2 - 1 <= CCHMAXLINEQP) {
	/*Note: in practice only this clause should happen*/
	/*void*/sbOut.append( str );
      } else {
	/*void*/sbOut.append( "=\r\n" );
	/*void*/sbOut.append( str );
      }
      ichLine = 0;
    } else {
      /*void*/sbOut.append( "=\r\n" );
      /*void*/sbOut.append( str );
      ichLine = str.length(  ) - 1;
    }

    return ichLine;
  }


  static private
  int  append  (StringBuffer	sbOut	,
		int		ichLine	,
		char		ch	)
  {
    return append( sbOut , ichLine , String.valueOf( ch ) );
  }


//???integrate back in since only called from one place?
  /**
   * Does semi-generic line folding.
   *
   * Note: if strWrapper includes a chars on the current line,
   * then cchMaxLine must be that many chars less than the true max
   * in order to leave space for those chars.
   */
//???should really have a cchCurrLine to account for the above mentioned sit.
  static private
  String  fold  (String	strIn		,
		 String	strLineTerm	, // existing line term
		 String	strWrapper	, // line break, etc
		 int	cchWrapLine	, // chars into new line of strWrapper
		 int	cchMaxLine	)
  throws NullPointerException
  {
    StringBuffer	sbOut;
    int			cchIn;
    int			ichIn;
    int			cchLine;

    if (strIn == null) {
      throw new NullPointerException( mc_strModuleName +
		": (String) strIn is null" );
    }

    cchIn = strIn.length(  );

    /*Note: translation will be somewhat larger*/
    sbOut = new StringBuffer( (int)(cchIn * 1.1) );

    ichIn = 0;
    cchLine = 0;
    for ( ; ichIn < cchIn ; ) {
      if (strIn.startsWith( strLineTerm , ichIn )) {
	/*void*/sbOut.append( strLineTerm );
	ichIn += strLineTerm.length(  );
	cchLine = 0;
      } else {
	/*void*/sbOut.append( strIn.charAt( ichIn ) );
	ichIn++;
	cchLine++;
//???doing this here can cause an unnec fold (just before a line break)
	if (cchLine >= cchMaxLine) {	/*Note: should not be >*/
	  /*void*/sbOut.append( strWrapper );
	  cchLine = cchWrapLine;
	}
      }
    }

    return sbOut.toString(  );
  }

					
/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/
  final static public  String	mc_strModuleName	= "Utilities";


/*----------------------------------------------------------------------------
 *						Private Constants
 *--------------------------------------------------------------------------*/

  final static public  int	HEXRADIX		= 16;

  /* as defined by ical: */
  final static public  int	CCHMAXLINEICAL		= 75;	// w/o CRLF
  final static public  int	CCHMAXLINEQP		= 76 - 1;
				// w/o CRLF plus a place for the = of =CRLF


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void
  main  (String	argv[]	)
  {
    byte[]	abyte		= new byte[10000];
    int		cbyte		= 0;
    int		status;
    String	str;

    try {
      for (cbyte = 0 ;
	   -1 != (status = System.in.read(
			abyte , cbyte , abyte.length - cbyte )) ;
	   cbyte += status) {
	;	// null statement
      }
    } catch (java.io.IOException	e	) {
      /*void*/e.printStackTrace(  );
    }

    System.out.println( "bytes read: " + cbyte );
    /*void*/System.out.println( "======================================" +
				"=====================================" );
    System.out.print( new String( abyte , 0 , cbyte ) );
    /*void*/System.out.println( "======================================" +
				"=====================================" );

    str = encode( new String( abyte , 0 , cbyte ) );

    /*void*/System.out.println( "======================================" +
				"=====================================" );
    System.out.print( str );
    /*void*/System.out.println( "======================================" +
				"=====================================" );
  }

}


/* Note: update class header too */
/* Log:
 * 0.04  2003/09/24  slh
 *       encodeMime(): reworked
 * 0.03  2002/02/26  slh
 *       splitNumber(): throw NumberFormatException
 * 0.02  2002/02/19, 2002/02/25 - 2002/02/26  slh
 *       cleaned up and make (more complete) the encode/decode methods
 * 0.01  2002/02/13  slh
 *       add: splitNumber()
 * 0.00  2001/11/20 - 2001/11/21  slh
 *       create
 */
/*--Utilities.java----------------------------------------------------------*/
