/*++UnsupProp.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * Base class for unsupported iCalendar properties.
 *
 * Basically a text-valued property with an unchecked value and
 * allowing any parameters.
 *
 * @author  slh
 * @version  0.11 2003/04/23 slh
 */
abstract public
class  UnsupProp
extends  Property
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /* this is the base constructor */
  /**
   * Create an unsupported property, unset.
   */
  protected
  UnsupProp  (String	strName	)
  {
    super( strName );
  }


  /**
   * Create an unsupported property set to supplied value.
   */
  protected
  UnsupProp  (String	strName		,
	      String	strValue	)
  {
    this( strName );

    /*void*/set( strValue );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    return m_strValue != null && super.isComplete(  );
  }


  public
  boolean
  isSupported  (		)
  {
    return false;
  }


  public
  String
  get  (		)
  {
    return getString(  );
  }


  public
  void
  set  (String	strValue	)
  {
    m_strValue = strValue;
  }


  public
  String
  getString  (		)
  {
    return m_strValue;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( Parameter.class );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  protected  String	m_strValue	= null;

}


/* Log:
 *  0.11  2003/01/21 - 2003/01/22, 2003/04/23  slh
 *        (new year, new version...)
 *        configProperty(): lists all parameters; drop addParameter()
 *  0.10  2002/12/04, 2002/12/10  slh
 *        drop toString() (let super do it with getString())
 *        m_strImage -> m_strValue
 *        redo constructors
 *        allow any parameters
 *        implement ch in Collectible: isComplete(), isSupported()
 *        update for ch in Property: configProperty()
 *        no default constructor; UnsupProp(String,String); misc
 *  0.01  2001/08/14  slh
 *        toString(): now outputs name; add: getString(); misc
 *  0.00  2001/04/25, 2001/05/02  slh
 *        create
 */
/*--UnsupProp.java----------------------------------------------------------*/
