/*++UnsupParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * Base class for unsupported iCalendar parameters.
 *
 * Basically a text-valued parameter with an unchecked value.
 *
 * @author  slh
 * @version  0.10 2002/12/10 slh
 */
abstract public
class  UnsupParam
extends  Parameter
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /* this is the base constructor */
  /**
   * Create an unsupported parameter, unset.
   */
  protected
  UnsupParam  (String	strName	)
  {
    super( strName );
  }


  /**
   * Create an unsupported parameter set to supplied value.
   */
  protected
  UnsupParam  (String	strName		,
	       String	strValue	)
  {
    this( strName );

    /*void*/set( strValue );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    return m_strValue != null;
  }


  public
  boolean
  isSupported  (		)
  {
    return false;
  }


  public
  String
  get  (		)
  {
    return getString(  );
  }


  public
  void
  set  (String	strValue	)
  {
    m_strValue = strValue;
  }


  public
  String
  getString  (		)
  {
    return m_strValue;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  /* all concatentated together */
  protected  String	m_strValue	= null;

}


/* Log:
 *  0.10  2002/12/04, 2002/12/10  slh
 *        drop toString() (let super do it with getString())
 *        m_strImage -> m_strValue
 *        implement ch in Collectible: isComplete(), isSupported()
 *        no default constructor; UnsupProp(String,String); misc
 *  0.01  2001/08/14  slh
 *        toString(): now outputs name; add: getString(); misc
 *  0.00  2001/04/25, 2001/05/02  slh
 *        create
 */
/*--UnsupParam.java---------------------------------------------------------*/
