/*++UnsupComp.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * Base class for unsupported iCalendar components.
 *
 * Allows any components and properties.
 *
 * @author  slh
 * @version  0.20 2003/04/23 slh
 */
abstract public
class  UnsupComp
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  protected
  UnsupComp  (String	strName	)
  {
    super( strName );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    return (m_components.size(  ) > 0 || m_properties.size(  ) > 0) &&
		m_components.isComplete(  ) && m_properties.isComplete(  );
  }


  public
  boolean
  isSupported  (		)
  {
    return false;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configComponent  (		)
  {
    m_vCompZeroPlus = new Vector(  );
    m_vCompZeroPlus.add( Component.class );

    m_vPropZeroPlus = new Vector(  );
    m_vPropZeroPlus.add( Property.class );
  }

}


/* Log:
 *  0.20  2003/01/22, 2003/04/23  slh
 *        (new year, new version...)
 *        configComponent(); list all; drop addComponent(), addProperty()
 *  0.10  2002/12/04  slh
 *        allow any components and properties
 *        implement ch in Collectible: isComplete(), isSupported()
 *        update for ch in Component: configComponent()
 *        no default constructor; UnsupProp(String,String); misc
 *  0.00  2001/05/09  slh
 *        create
 */
/*--UnsupComp.java----------------------------------------------------------*/
