/*++URL.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * Calendar URL property.
 *
 * Spec:
 *   section:	4.8.4.6 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL, VFREEBUSY (0-1)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *   params:	xparam(0+)
 *
 * @author  slh
 * @version  0.10 2003/04/22 slh
 */
public
class  URL
extends  URIProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a URL property, unset.
   */
  public
  URL  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a URL property set to supplied value.
   */
  protected
  URL  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_URL;
  }

}


/* Log:
 *  0.10  2003/04/22  slh
 *        getCalendarName()
 *        redo constructors
 *        rm main()
 *  0.00  2001/05/08 - 2001/05/09  slh
 *        create
 */
/*--URL.java----------------------------------------------------------------*/
