/*++URIProp.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.net.URL;


/**
 * Base class for ICalendar URI-valued properties.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.3.13 [2445]
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2002/12/03 slh
 */
abstract public
class  URIProp
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /**
   * Create a URI property unset.
   */
  protected
  URIProp  (String	strName	)
  {
    super( strName );
  }


  /**
   * Create a URI property set to supplied value.
   */
  protected
  URIProp  (String	strName		,
	    String	strValue	)
  {
/*???
    super( strName , strValue );
*/
    super( strName );
    try {
      /*void*/set( strValue );
    } catch (Exception	e	) {
      throw new IllegalArgumentException( e.getLocalizedMessage(  ) );
    }
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  set  (String	strValue	)
  throws Exception
  {
    URL		url;

    /*Note: not stricly correct, but then neither is using URL for uris*/
    if (m_strScheme != null &&
	!strValue.toLowerCase(  ).startsWith(
		m_strScheme.toLowerCase(  ) + ":" )) {
      throw new IllegalArgumentException( getName(  ) +
		": URL: " + strValue + " is not of scheme: " + m_strScheme );
    }

    /*Note: checks format*/
    url = new URL( "http" + strValue.substring( strValue.indexOf( ":" ) ) );

//???this is what it should look like, if any scheme was accepted
/*???
    url = new URL( strValue );

    if (m_strScheme != null &&
	!m_strScheme.equalsIgnoreCase( url.getProtocol(  ) )) {
      throw new IllegalArgumentException( getName(  ) +
		": URL: " + strValue + " is not of scheme: " + m_strScheme );
    }
*/

    super.set( strValue );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  /**
   * Restricts allowed scheme.
   * Unrestricted if null.
   */
  protected String	m_strScheme		= null;

}


/* Log:
 *  0.10  2002/12/03  slh
 *        redo, including being able to restrict to a scheme
 *  0.00  2001/05/08  slh
 *        create
 */
/*--URIProp.java------------------------------------------------------------*/
