/*++UID.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * iCalendar UID property.
 *
 * Spec:
 *   section:	4.8.4.7 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL, VFREEBUSY (1)???
 *???(4.8.4.7 says MUST, containing components say optional (0-1))
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *   params:	xparam(0+)
 *
 * Currently: thin wrapper around TextProp.
 *
 * @author  slh
 * @version  0.10 2003/04/22 slh
 */
public
class  UID
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a UID property, unset.
   */
  public
  UID  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a UID property set to supplied value.
   */
  protected
  UID  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_UID;
  }

}


/* Log:
 *  0.10  2003/04/22  slh
 *        getCalendarName()
 *        redo constructors
 *        rm main()
 *  0.00  2001/04/25, 2001/05/02, 2001/05/08 - 2001/05/09  slh
 *        create
 */
/*--UID.java----------------------------------------------------------------*/
