/*++Trigger.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Date;
import  java.util.Vector;


/**
 * iCalendar TRIGGER property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 *   section:	4.8.6.3 [2445]
 *   occurs:	VALARM (1)
 *   datatypes:	DURATION, DATE-TIME/utc (1)
 *   default:	---
 *   allowed:	---
 *   params:	VALUE(0-1), RELATED(0-1)*, xparam(0+)
 * * see quotes below
 *
 * ``The default duration is relative to the start of an event or to-do
 *   that the alarm is associated with.''
 * ``If the trigger is set relative to START, then the "DTSTART" property
 *   MUST be present in the associated "VEVENT" or "VTODO" calendar
 *   component. If an alarm is specified for an event with the trigger set
 *   relative to the END, then the "DTEND" property or the "DSTART" and
 *   "DURATION' properties MUST be present in the associated "VEVENT"
 *   calendar component. If the alarm is specified for a to-do with a
 *   trigger set relative to the END, then either the "DUE" property or
 *   the "DSTART" and "DURATION' properties MUST be present in the
 *   associated "VTODO" calendar component.''
 * ``
 *   trigger    = "TRIGGER" (trigrel / trigabs)
 * 
 *   trigrel    = *(
 *              ; the following are optional,
 *              ; but MUST NOT occur more than once
 *                (";" "VALUE" "=" "DURATION") /
 *                (";" trigrelparam) /
 *              ; the following is optional,
 *              ; and MAY occur more than once
 *                (";" xparam)
 *                ) ":"  dur-value
 *
 *   trigabs    = 1*(
 *              ; the following is REQUIRED,
 *              ; but MUST NOT occur more than once
 *                (";" "VALUE" "=" "DATE-TIME") /
 *              ; the following is optional,
 *              ; and MAY occur more than once
 *                (";" xparam)
 *                ) ":" date-time
 * ''
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/11/03 slh
 */
public
class  Trigger
extends  Property
{

/*----------------------------------------------------------------------------
 *						Inner Classes
 *--------------------------------------------------------------------------*/

  public
  class  TDuration
  extends  DurationProp
  {

    public
    TDuration  (		)
    {
      super( "TDuration" );
    }

  }


  public
  class  TTime
  extends  TimeProp
  {

    public
    TTime  (		)
    {
      super( "TTime" , TimeProp.DATETIME , true );
    }

  }


/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /* this is the base constructor */
  /**
   * Create an TRIGGER property, unset.
   */
  public
  Trigger  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a TRIGGER property set to supplied value.
   */
  public
  Trigger  (String	strValue	)
  {
    /*Note: letting calls handle any nulls*/
    this(  );
    try {
      /*void*/set( strValue );
    } catch (Exception	e	) {
      throw new IllegalArgumentException( getName(  ) +
		": " + e.getLocalizedMessage(  ) );
    }
  }


  /**
   * Create an TRIGGER property set to supplied value.
   */
  public
  Trigger  (Date	date	)
  {
    /*Note: letting calls handle any nulls*/
    this(  );
    /*void*/set( date );
  }


  /**
   * Create an TRIGGER property set to supplied value.
   */
  public
  Trigger  (Integer	IValue	)
  {
    /*Note: letting calls handle any nulls*/
    this(  );
    /*void*/set( IValue );
  }


  /**
   * Create an TRIGGER property set to supplied value.
   */
  public
  Trigger  (int	iValue	)
  {
    this(  );
    /*void*/set( iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Trigger;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    ValueParam	vp;

    if (m_Type != DURATION) {
      if (0 != m_parameters.getCount( RelatedParam.class )) {
	return false;						/*RETURN*/
      }
    }

    /*Note: constrained to be no more than one by property config*/
    vp = (ValueParam)m_parameters.getFirst( ValueParam.class );
    if (vp == null && m_Type == DURATION) {
      ;		// ok
    } else if (vp == null || m_Type != vp.getEnum(  )) {
      return false;						/*RETURN*/
    }

    return m_property != null && m_property.isComplete(  ) &&
		super.isComplete(  );				/*RETURN*/
  }


  /**
   * Get TRIGGER value type.
   */
  public
  int
  getType  (		)
  {
    return m_Type;
  }


  /**
   * Get duration.
   */
  public
  int
  getDuration  (		)
  throws NoValueException
  {
    if (m_Type == DURATION) {
      if (m_property != null) {
	return ((TDuration)m_property).get(  );
      } else {
	throw new NoValueException( getName(  ) + ": no value set" );
      }
    } else {
//???
      throw new RuntimeException(  );
    }
  }


  /**
   * Get date/time as a Date.
   */
  public
  Date
  getDate  (		)
  throws NoValueException
  {
    if (m_Type == DATETIME) {
//???second test eventually in TimeProp
      if (m_property != null && ((TTime)m_property).get(  ) != null) {
	return ((TTime)m_property).get(  );
      } else {
	throw new NoValueException( getName(  ) +
			": property value is unset" );
      }
    } else {
//???
      throw new RuntimeException(  );
    }
  }


  /**
   * Set TRIGGER value type.
   */
  public
  void
  setType  (int		Type	)
  throws IllegalArgumentException
  {
    Collectible		coll;

    switch (Type) {
    case DURATION:
    case DATETIME:
      if (m_Type != Type) {
	if (null !=
	    (coll = m_parameters.getFirst( ValueParam.class ))) {
	  /* let throw exception if does,
	     though there should never be a problem */
	  /*void*/m_parameters.remove( coll );
	}
	if (Type != DURATION) {
	  /*void*/addAnyParameter( new ValueParam( Type ) );
	}
	if (Type == DURATION) {
	  m_property = new TDuration(  );
	} else {
	  m_property = new TTime(  );
	}
	m_Type = Type;
      }
      break;
    case NONE:
    default:
      throw new IllegalArgumentException( getName(  ) + ": illegal type" );
/*
      break;
*/
    }
  }


  /**
   * Set TRIGGER with a duration.
   */
  public
  void
  set  (Integer	IDuration	)
  {
    /*void*/setType( DURATION );
    /*Note: setType() call assures m_property not null*/
    /*void*/((TDuration)m_property).set( IDuration );
  }


  /**
   * Set TRIGGER with a duration.
   */
  public
  void
  set  (int	Duration	)
  {
    /*void*/setType( DURATION );
    /*Note: setType() call assures m_property not null*/
    /*void*/((TDuration)m_property).set( Duration );
  }


  /**
   * Set TRIGGER with a Date.
   */
  public
  void
  set  (Date	date	)
  {
    /*void*/setType( DATETIME );
    /*Note: setType() call assures m_property not null*/
    /*void*/((TTime)m_property).set( date , DATETIME );
  }


  /**
   * Set TRIGGER and value type with a string.
   */
  public
  void
  set  (String	strValue	)
  throws Exception
  {
    /* if a duration... */
    if (strValue.startsWith( "P" )) {
      /*void*/setType( DURATION );
    } else {
      /*void*/setType( DATETIME );
    }
    /*Note: setType() call assures m_property not null*/
    /*void*/m_property.set( strValue );
  }


  /**
   * Get TRIGGER as a string.
   */
  public
  String
  getString  (		)
  {
    return m_property == null ? "" : m_property.getString(  );
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	NONE		= TimeProp.NONE;
  final static public  int	DURATION	= ValueParam.DURATION;
  final static public  int	DATETIME	= TimeProp.DATETIME;


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroOne = new Vector(  );
    /*void*/m_vParamZeroOne.add( ValueParam.class );
    /*void*/m_vParamZeroOne.add( RelatedParam.class );

    m_vParamZeroPlus = new Vector(  );
    /*void*/m_vParamZeroPlus.add( XParam.class );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  protected  int		m_Type		= NONE;
  protected  Property		m_property	= null;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void
  main  (String	argv[]	)
  {
    Trigger	trigger;

    try {
      trigger = new Trigger(  );
      /*void*/System.out.println( trigger.isComplete(  ) );
      /*void*/System.out.println( trigger );

      /*void*/trigger.set( "PT5M" );
      /*void*/System.out.println( trigger.isComplete(  ) );
      /*void*/System.out.println( trigger );

      /*void*/trigger.set( "20031014T121212Z" );
      /*void*/System.out.println( trigger.isComplete(  ) );
      /*void*/System.out.println( trigger );

      /*void*/trigger.set( 10 );
      /*void*/System.out.println( trigger.isComplete(  ) );
      /*void*/System.out.println( trigger );

      /*void*/trigger.set( new Date(  ) );
      /*void*/System.out.println( trigger.isComplete(  ) );
      /*void*/System.out.println( trigger );

      /*void*/trigger.addParameter( new ValueParam( ValueParam.DURATION ) );
      /*void*/System.out.println( trigger.isComplete(  ) );
      /*void*/System.out.println( trigger );

      /*void*/trigger.setType( trigger.DURATION );
      /*void*/System.out.println( trigger.isComplete(  ) );
      /*void*/System.out.println( trigger );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
  }

}


/* Log:
 *  0.10  2003/10/14 - 2003/10/15, 2003/10/20, 2003/10/29, 2003/11/03  slh
 *        adjust for ValueTypeParam -> ValueParam
 *        use *.class instead of Names.*
 *        derive from Property (instead of UnsupProp)
 *  0.00  2003/02/21  slh
 *        create
 */
/*--Trigger.java------------------------------------------------------------*/
