/*++Transp.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar TRANSP property.
 *
 * Spec:
 *   section:	4.8.2.7 [2445]
 *   occurs:	VEVENT (0-1)
 *   datatypes:	TEXT/enum (1)
 *   default:	"OPAQUE"
 *   allowed:	"OPAQUE", "TRANSPARENT"
 *   params:	xparam(0+)
 *
 * @author  slh
 * @version  0.00 2003/04/21 slh
 */
public
class  Transp
extends  EnumProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a TRANSP property, set to default.
   */
  public
  Transp  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a TRANSP property set to supplied value.
   */
  public
  Transp  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a TRANSP property set to supplied value.
   */
  public
  Transp  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Transp;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    /*(void)*/m_hmValue.put(
		new Integer( OPAQUE ) , Names.strValue_Opaque );
    /*(void)*/m_hmValue.put(
		new Integer( TRANSPARENT ) , Names.strValue_Transparent );

    m_strDefault = Names.strValue_Opaque;
  }

/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	OPAQUE		= 1;
  final static public  int	TRANSPARENT	= 2;

}


/* Log:
 *  0.10  2003/03/05, 2003/04/21  slh
 *        wrong default (cnp error)
 *        redo constructors
 *        configEnum(): drop set(), setEnum()
 *        getCalendarName()
 *  0.00  2001/04/25  slh
 *        create
 */
/*--Transp.java-------------------------------------------------------------*/
